/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.mac;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.unix.LibCAPI;
import com.sun.jna.ptr.IntByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.mac.SystemB;
import oshi.jna.platform.unix.NativeSizeTByReference;

@ThreadSafe
public final class SysctlUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SysctlUtil.class);
    private static final String SYSCTL_FAIL = "Failed syctl call: {}, Error code: {}";

    private SysctlUtil() {
    }

    public static int sysctl(String name, int def) {
        IntByReference size = new IntByReference(com.sun.jna.platform.mac.SystemB.INT_SIZE);
        Memory p = new Memory(size.getValue());
        if (0 != SystemB.INSTANCE.sysctlbyname(name, (Pointer)p, size, null, 0)) {
            LOG.error("Failed sysctl call: {}, Error code: {}", (Object)name, (Object)Native.getLastError());
            return def;
        }
        return ((Pointer)p).getInt(0L);
    }

    public static long sysctl(String name, long def) {
        IntByReference size = new IntByReference(com.sun.jna.platform.mac.SystemB.UINT64_SIZE);
        Memory p = new Memory(size.getValue());
        if (0 != SystemB.INSTANCE.sysctlbyname(name, (Pointer)p, size, null, 0)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        return ((Pointer)p).getLong(0L);
    }

    public static String sysctl(String name, String def) {
        NativeSizeTByReference size = new NativeSizeTByReference();
        if (0 != SystemB.INSTANCE.sysctlbyname(name, null, size, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        Memory p = new Memory(size.getValue().longValue() + 1L);
        if (0 != SystemB.INSTANCE.sysctlbyname(name, (Pointer)p, size, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        return p.getString(0L);
    }

    public static boolean sysctl(String name, Structure struct) {
        if (0 != SystemB.INSTANCE.sysctlbyname(name, struct.getPointer(), new NativeSizeTByReference(new LibCAPI.size_t((long)struct.size())), null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return false;
        }
        struct.read();
        return true;
    }

    public static Memory sysctl(String name) {
        NativeSizeTByReference size = new NativeSizeTByReference();
        if (0 != SystemB.INSTANCE.sysctlbyname(name, null, size, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return null;
        }
        Memory m = new Memory(size.getValue().longValue());
        if (0 != SystemB.INSTANCE.sysctlbyname(name, (Pointer)m, size, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return null;
        }
        return m;
    }
}

