/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers.nbt.io;

import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtList;
import com.comphenix.protocol.wrappers.nbt.NbtWrapper;
import com.comphenix.protocol.wrappers.nbt.io.NbtBinarySerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class NbtTextSerializer {
    public static final NbtTextSerializer DEFAULT = new NbtTextSerializer();
    private NbtBinarySerializer binarySerializer;

    public NbtTextSerializer() {
        this(new NbtBinarySerializer());
    }

    public NbtTextSerializer(NbtBinarySerializer binary) {
        this.binarySerializer = binary;
    }

    public NbtBinarySerializer getBinarySerializer() {
        return this.binarySerializer;
    }

    public <TType> String serialize(NbtBase<TType> value) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(outputStream);
        this.binarySerializer.serialize(value, dataOutput);
        return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
    }

    public <TType> NbtWrapper<TType> deserialize(String input) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)input));
        return this.binarySerializer.deserialize(new DataInputStream(inputStream));
    }

    public NbtCompound deserializeCompound(String input) throws IOException {
        return (NbtCompound)((Object)this.deserialize(input));
    }

    public <T> NbtList<T> deserializeList(String input) throws IOException {
        return (NbtList)((Object)this.deserialize(input));
    }
}

