/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.collect.Maps;
import java.util.Map;

public abstract class EnumWrappers {
    private static Class<?> PROTOCOL_CLASS = null;
    private static Class<?> CLIENT_COMMAND_CLASS = null;
    private static Class<?> CHAT_VISIBILITY_CLASS = null;
    private static Class<?> DIFFICULTY_CLASS = null;
    private static Class<?> ENTITY_USE_ACTION_CLASS = null;
    private static Class<?> GAMEMODE_CLASS = null;
    private static Map<Class<?>, EquivalentConverter<?>> FROM_NATIVE = Maps.newHashMap();
    private static Map<Class<?>, EquivalentConverter<?>> FROM_WRAPPER = Maps.newHashMap();

    private static void initialize() {
        if (!MinecraftReflection.isUsingNetty()) {
            throw new IllegalArgumentException("Not supported on 1.6.4 and earlier.");
        }
        PROTOCOL_CLASS = EnumWrappers.getEnum(PacketType.Handshake.Client.SET_PROTOCOL.getPacketClass(), 0);
        CLIENT_COMMAND_CLASS = EnumWrappers.getEnum(PacketType.Play.Client.CLIENT_COMMAND.getPacketClass(), 0);
        CHAT_VISIBILITY_CLASS = EnumWrappers.getEnum(PacketType.Play.Client.SETTINGS.getPacketClass(), 0);
        DIFFICULTY_CLASS = EnumWrappers.getEnum(PacketType.Play.Client.SETTINGS.getPacketClass(), 1);
        ENTITY_USE_ACTION_CLASS = EnumWrappers.getEnum(PacketType.Play.Client.USE_ENTITY.getPacketClass(), 0);
        GAMEMODE_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.LOGIN.getPacketClass(), 0);
        EnumWrappers.associate(PROTOCOL_CLASS, PacketType.Protocol.class, EnumWrappers.getClientCommandConverter());
        EnumWrappers.associate(CLIENT_COMMAND_CLASS, ClientCommand.class, EnumWrappers.getClientCommandConverter());
        EnumWrappers.associate(CHAT_VISIBILITY_CLASS, ChatVisibility.class, EnumWrappers.getChatVisibilityConverter());
        EnumWrappers.associate(DIFFICULTY_CLASS, Difficulty.class, EnumWrappers.getDifficultyConverter());
        EnumWrappers.associate(ENTITY_USE_ACTION_CLASS, EntityUseAction.class, EnumWrappers.getEntityUseActionConverter());
        EnumWrappers.associate(GAMEMODE_CLASS, NativeGameMode.class, EnumWrappers.getGameModeConverter());
    }

    private static void associate(Class<?> nativeClass, Class<?> wrapperClass, EquivalentConverter<?> converter) {
        FROM_NATIVE.put(nativeClass, converter);
        FROM_WRAPPER.put(wrapperClass, converter);
    }

    private static Class<?> getEnum(Class<?> clazz, int index) {
        return FuzzyReflection.fromClass(clazz, true).getFieldListByType(Enum.class).get(index).getType();
    }

    public static Map<Class<?>, EquivalentConverter<?>> getFromNativeMap() {
        return FROM_NATIVE;
    }

    public static Map<Class<?>, EquivalentConverter<?>> getFromWrapperMap() {
        return FROM_WRAPPER;
    }

    public static Class<?> getProtocolClass() {
        EnumWrappers.initialize();
        return PROTOCOL_CLASS;
    }

    public static Class<?> getClientCommandClass() {
        EnumWrappers.initialize();
        return CLIENT_COMMAND_CLASS;
    }

    public static Class<?> getChatVisibilityClass() {
        EnumWrappers.initialize();
        return CHAT_VISIBILITY_CLASS;
    }

    public static Class<?> getDifficultyClass() {
        EnumWrappers.initialize();
        return DIFFICULTY_CLASS;
    }

    public static Class<?> getEntityUseActionClass() {
        EnumWrappers.initialize();
        return ENTITY_USE_ACTION_CLASS;
    }

    public static Class<?> getGameModeClass() {
        EnumWrappers.initialize();
        return GAMEMODE_CLASS;
    }

    public static EquivalentConverter<PacketType.Protocol> getProtocolConverter() {
        return new EnumConverter<PacketType.Protocol>(PacketType.Protocol.class);
    }

    public static EquivalentConverter<ClientCommand> getClientCommandConverter() {
        return new EnumConverter<ClientCommand>(ClientCommand.class);
    }

    public static EquivalentConverter<ChatVisibility> getChatVisibilityConverter() {
        return new EnumConverter<ChatVisibility>(ChatVisibility.class);
    }

    public static EquivalentConverter<Difficulty> getDifficultyConverter() {
        return new EnumConverter<Difficulty>(Difficulty.class);
    }

    public static EquivalentConverter<EntityUseAction> getEntityUseActionConverter() {
        return new EnumConverter<EntityUseAction>(EntityUseAction.class);
    }

    public static EquivalentConverter<NativeGameMode> getGameModeConverter() {
        return new EnumConverter<NativeGameMode>(NativeGameMode.class);
    }

    private static class EnumConverter<T extends Enum<T>>
    implements EquivalentConverter<T> {
        private Class<T> specificType;

        public EnumConverter(Class<T> specificType) {
            this.specificType = specificType;
        }

        @Override
        public T getSpecific(Object generic) {
            return Enum.valueOf(this.specificType, ((Enum)generic).name());
        }

        @Override
        public Object getGeneric(Class<?> genericType, T specific) {
            return Enum.valueOf(genericType, ((Enum)specific).name());
        }

        @Override
        public Class<T> getSpecificType() {
            return this.specificType;
        }
    }

    public static enum NativeGameMode {
        NONE,
        SURVIVAL,
        CREATIVE,
        ADVENTURE;

    }

    public static enum EntityUseAction {
        INTERACT,
        ATTACK;

    }

    public static enum Difficulty {
        PEACEFUL,
        EASY,
        NORMAL,
        HARD;

    }

    public static enum ChatVisibility {
        FULL,
        SYSTEM,
        HIDDEN;

    }

    public static enum ClientCommand {
        PERFORM_RESPAWN,
        REQUEST_STATS,
        OPEN_INVENTORY_ACHIEVEMENT;

    }
}

