/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import com.comphenix.protocol.reflect.FieldUtils;
import com.comphenix.protocol.reflect.MethodUtils;
import com.comphenix.protocol.utility.ClassSource;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;

class RemappedClassSource
extends ClassSource {
    private Object classRemapper;
    private Method mapType;
    private ClassLoader loader;

    public RemappedClassSource() {
        this(RemappedClassSource.class.getClassLoader());
    }

    public RemappedClassSource(ClassLoader loader) {
        this.loader = loader;
    }

    public RemappedClassSource initialize() {
        try {
            if (Bukkit.getServer() == null) {
                throw new RemapperUnavailableException(RemapperUnavailableException.Reason.BUKKIT_NOT_INIT);
            }
            if (!this.triesForgeIntegration(Bukkit.getVersion())) {
                throw new RemapperUnavailableException(RemapperUnavailableException.Reason.MCPC_NOT_PRESENT);
            }
            this.classRemapper = FieldUtils.readField(this.getClass().getClassLoader(), "remapper", true);
            if (this.classRemapper == null) {
                throw new RemapperUnavailableException(RemapperUnavailableException.Reason.REMAPPER_DISABLED);
            }
            Class<?> renamerClazz = this.classRemapper.getClass();
            this.mapType = MethodUtils.getAccessibleMethod(renamerClazz, "map", new Class[]{String.class});
            return this;
        }
        catch (RemapperUnavailableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot access MCPC remapper.", e);
        }
    }

    private boolean triesForgeIntegration(String version) {
        return version.contains("MCPC") || version.contains("Cauldron") || version.contains("Thermos");
    }

    @Override
    public Class<?> loadClass(String canonicalName) throws ClassNotFoundException {
        String remapped = this.getClassName(canonicalName);
        try {
            return this.loader.loadClass(remapped);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException("Cannot find " + canonicalName + "(Remapped: " + remapped + ")");
        }
    }

    public String getClassName(String path) {
        try {
            String remapped = (String)this.mapType.invoke(this.classRemapper, path.replace('.', '/'));
            return remapped.replace('/', '.');
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot remap class name.", e);
        }
    }

    public static class RemapperUnavailableException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final Reason reason;

        public RemapperUnavailableException(Reason reason) {
            super(reason.getMessage());
            this.reason = reason;
        }

        public Reason getReason() {
            return this.reason;
        }

        public static enum Reason {
            BUKKIT_NOT_INIT("Bukkit is not initialized"),
            MCPC_NOT_PRESENT("The server is not running Forge+Bukkit"),
            REMAPPER_DISABLED("Running a Forge+Bukkit server but the remapper is unavailable. Please turn it on!");

            private final String message;

            private Reason(String message) {
                this.message = message;
            }

            public String getMessage() {
                return this.message;
            }
        }
    }
}

