/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.fuzzy;

import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMatcher;
import com.google.common.base.Objects;

class ClassExactMatcher
extends AbstractFuzzyMatcher<Class<?>> {
    public static final ClassExactMatcher MATCH_ALL = new ClassExactMatcher(null, Options.MATCH_SUPER);
    private final Class<?> matcher;
    private final Options option;

    ClassExactMatcher(Class<?> matcher, Options option) {
        this.matcher = matcher;
        this.option = option;
    }

    @Override
    public boolean isMatch(Class<?> input, Object parent) {
        if (input == null) {
            throw new IllegalArgumentException("Input class cannot be NULL.");
        }
        if (this.matcher == null) {
            return this.option != Options.MATCH_EXACT;
        }
        if (this.option == Options.MATCH_SUPER) {
            return input.isAssignableFrom(this.matcher);
        }
        if (this.option == Options.MATCH_DERIVED) {
            return this.matcher.isAssignableFrom(input);
        }
        return input.equals(this.matcher);
    }

    @Override
    protected int calculateRoundNumber() {
        return -ClassExactMatcher.getClassNumber(this.matcher);
    }

    public static int getClassNumber(Class<?> clazz) {
        int count = 0;
        while (clazz != null) {
            ++count;
            clazz = clazz.getSuperclass();
        }
        return count;
    }

    public Class<?> getMatcher() {
        return this.matcher;
    }

    public Options getOptions() {
        return this.option;
    }

    public String toString() {
        if (this.option == Options.MATCH_SUPER) {
            return this.matcher + " instanceof input";
        }
        if (this.option == Options.MATCH_DERIVED) {
            return "input instanceof " + this.matcher;
        }
        return "Exact " + this.matcher;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.matcher, this.option});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClassExactMatcher) {
            ClassExactMatcher other = (ClassExactMatcher)obj;
            return Objects.equal(this.matcher, other.matcher) && Objects.equal((Object)((Object)this.option), (Object)((Object)other.option));
        }
        return false;
    }

    static enum Options {
        MATCH_EXACT,
        MATCH_SUPER,
        MATCH_DERIVED;

    }
}

