/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.cloning;

import com.comphenix.protocol.reflect.cloning.Cloner;
import com.comphenix.protocol.reflect.cloning.ImmutableDetector;
import com.comphenix.protocol.reflect.cloning.SerializableCloner;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;

public class CollectionCloner
implements Cloner {
    private final Cloner defaultCloner;

    public CollectionCloner(Cloner defaultCloner) {
        this.defaultCloner = defaultCloner;
    }

    @Override
    public boolean canClone(Object source) {
        if (source == null) {
            return false;
        }
        Class<?> clazz = source.getClass();
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || clazz.isArray();
    }

    @Override
    public Object clone(Object source) {
        if (source == null) {
            throw new IllegalArgumentException("source cannot be NULL.");
        }
        Class<?> clazz = source.getClass();
        if (source instanceof Collection) {
            Collection copy = (Collection)this.cloneConstructor(Collection.class, clazz, source);
            try {
                copy.clear();
                for (Object element : (Collection)source) {
                    copy.add(this.getClone(element, source));
                }
            }
            catch (UnsupportedOperationException i$) {
                // empty catch block
            }
            return copy;
        }
        if (source instanceof Map) {
            Map copy = (Map)this.cloneConstructor(Map.class, clazz, source);
            try {
                copy.clear();
                for (Map.Entry element : ((Map)source).entrySet()) {
                    Object key = this.getClone(element.getKey(), source);
                    Object value = this.getClone(element.getValue(), source);
                    copy.put(key, value);
                }
            }
            catch (UnsupportedOperationException i$) {
                // empty catch block
            }
            return copy;
        }
        if (clazz.isArray()) {
            int lenght = Array.getLength(source);
            Class<?> component = clazz.getComponentType();
            if (ImmutableDetector.isImmutable(component)) {
                return this.clonePrimitive(component, source);
            }
            Object copy = Array.newInstance(clazz.getComponentType(), lenght);
            for (int i = 0; i < lenght; ++i) {
                Object element = Array.get(source, i);
                if (!this.defaultCloner.canClone(element)) {
                    throw new IllegalArgumentException("Cannot clone " + element + " in array " + source);
                }
                Array.set(copy, i, this.defaultCloner.clone(element));
            }
            return copy;
        }
        throw new IllegalArgumentException(source + " is not an array nor a Collection.");
    }

    private Object getClone(Object element, Object container) {
        if (this.defaultCloner.canClone(element)) {
            return this.defaultCloner.clone(element);
        }
        throw new IllegalArgumentException("Cannot clone " + element + " in container " + container);
    }

    private Object clonePrimitive(Class<?> component, Object source) {
        if (Byte.TYPE.equals(component)) {
            return ((byte[])source).clone();
        }
        if (Short.TYPE.equals(component)) {
            return ((short[])source).clone();
        }
        if (Integer.TYPE.equals(component)) {
            return ((int[])source).clone();
        }
        if (Long.TYPE.equals(component)) {
            return ((long[])source).clone();
        }
        if (Float.TYPE.equals(component)) {
            return ((float[])source).clone();
        }
        if (Double.TYPE.equals(component)) {
            return ((double[])source).clone();
        }
        if (Character.TYPE.equals(component)) {
            return ((char[])source).clone();
        }
        if (Boolean.TYPE.equals(component)) {
            return ((boolean[])source).clone();
        }
        return ((Object[])source).clone();
    }

    private <T> T cloneConstructor(Class<?> superclass, Class<?> clazz, Object source) {
        try {
            Constructor<?> constructCopy = clazz.getConstructor(Collection.class);
            return (T)constructCopy.newInstance(source);
        }
        catch (NoSuchMethodException e) {
            if (source instanceof Serializable) {
                return (T)new SerializableCloner().clone(source);
            }
            return (T)this.cloneObject(clazz, source);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot construct collection.", e);
        }
    }

    private Object cloneObject(Class<?> clazz, Object source) {
        try {
            return clazz.getMethod("clone", new Class[0]).invoke(source, new Object[0]);
        }
        catch (Exception e1) {
            throw new RuntimeException("Cannot copy " + source + " (" + clazz + ")", e1);
        }
    }

    public Cloner getDefaultCloner() {
        return this.defaultCloner;
    }
}

