/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import net.minecraft.util.io.netty.channel.ChannelOption;
import net.minecraft.util.io.netty.channel.socket.SocketChannel;

class NettySocketAdaptor
extends Socket {
    private final SocketChannel ch;

    private NettySocketAdaptor(SocketChannel ch) {
        this.ch = ch;
    }

    public static NettySocketAdaptor adapt(SocketChannel ch) {
        return new NettySocketAdaptor(ch);
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this.ch.bind(bindpoint).syncUninterruptibly();
    }

    @Override
    public synchronized void close() throws IOException {
        this.ch.close().syncUninterruptibly();
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.ch.connect(endpoint).syncUninterruptibly();
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.ch.config().setConnectTimeoutMillis(timeout);
        this.ch.connect(endpoint).syncUninterruptibly();
    }

    public boolean equals(Object obj) {
        return obj instanceof NettySocketAdaptor && this.ch.equals(((NettySocketAdaptor)obj).ch);
    }

    @Override
    public java.nio.channels.SocketChannel getChannel() {
        throw new UnsupportedOperationException("Operation not supported on Channel wrapper.");
    }

    @Override
    public InetAddress getInetAddress() {
        return this.ch.remoteAddress().getAddress();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("Operation not supported on Channel wrapper.");
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return (Boolean)this.ch.config().getOption(ChannelOption.SO_KEEPALIVE);
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.ch.localAddress().getAddress();
    }

    @Override
    public int getLocalPort() {
        return this.ch.localAddress().getPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.ch.localAddress();
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        throw new UnsupportedOperationException("Operation not supported on Channel wrapper.");
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("Operation not supported on Channel wrapper.");
    }

    @Override
    public int getPort() {
        return this.ch.remoteAddress().getPort();
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        return (Integer)this.ch.config().getOption(ChannelOption.SO_RCVBUF);
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.ch.remoteAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return (Boolean)this.ch.config().getOption(ChannelOption.SO_REUSEADDR);
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        return (Integer)this.ch.config().getOption(ChannelOption.SO_SNDBUF);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return (Integer)this.ch.config().getOption(ChannelOption.SO_LINGER);
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        throw new UnsupportedOperationException("Operation not supported on Channel wrapper.");
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return (Boolean)this.ch.config().getOption(ChannelOption.TCP_NODELAY);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return (Integer)this.ch.config().getOption(ChannelOption.IP_TOS);
    }

    public int hashCode() {
        return this.ch.hashCode();
    }

    @Override
    public boolean isBound() {
        return this.ch.localAddress() != null;
    }

    @Override
    public boolean isClosed() {
        return !this.ch.isOpen();
    }

    @Override
    public boolean isConnected() {
        return this.ch.isActive();
    }

    @Override
    public boolean isInputShutdown() {
        return this.ch.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.ch.isOutputShutdown();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        throw new UnsupportedOperationException("Operation not supported on Channel wrapper.");
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.ch.config().setOption(ChannelOption.SO_KEEPALIVE, (Object)on);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        throw new UnsupportedOperationException("Operation not supported on Channel wrapper.");
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        throw new UnsupportedOperationException("Operation not supported on Channel wrapper.");
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.ch.config().setOption(ChannelOption.SO_RCVBUF, (Object)size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.ch.config().setOption(ChannelOption.SO_REUSEADDR, (Object)on);
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.ch.config().setOption(ChannelOption.SO_SNDBUF, (Object)size);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.ch.config().setOption(ChannelOption.SO_LINGER, (Object)linger);
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        throw new UnsupportedOperationException("Operation not supported on Channel wrapper.");
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.ch.config().setOption(ChannelOption.TCP_NODELAY, (Object)on);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.ch.config().setOption(ChannelOption.IP_TOS, (Object)tc);
    }

    @Override
    public void shutdownInput() throws IOException {
        throw new UnsupportedOperationException("Operation not supported on Channel wrapper.");
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.ch.shutdownOutput().syncUninterruptibly();
    }

    @Override
    public String toString() {
        return this.ch.toString();
    }
}

