/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.injector.packet.MapContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NettyProtocolRegistry {
    private Class<?> enumProtocol = MinecraftReflection.getEnumProtocolClass();
    private volatile Register register;

    public NettyProtocolRegistry() {
        this.initialize();
    }

    public Map<PacketType, Class<?>> getPacketTypeLookup() {
        return Collections.unmodifiableMap(this.register.typeToClass);
    }

    public Map<Class<?>, PacketType> getPacketClassLookup() {
        return Collections.unmodifiableMap(this.register.typeToClass.inverse());
    }

    public Set<PacketType> getClientPackets() {
        return Collections.unmodifiableSet(this.register.clientPackets);
    }

    public Set<PacketType> getServerPackets() {
        return Collections.unmodifiableSet(this.register.serverPackets);
    }

    public synchronized void synchronize() {
        if (this.register.isOutdated()) {
            this.initialize();
        }
    }

    private synchronized void initialize() {
        ?[] protocols = this.enumProtocol.getEnumConstants();
        ArrayList serverMaps = Lists.newArrayList();
        ArrayList clientMaps = Lists.newArrayList();
        StructureModifier modifier = null;
        Register result = new Register();
        for (Object protocol : protocols) {
            if (modifier == null) {
                modifier = new StructureModifier(protocol.getClass().getSuperclass(), false);
            }
            StructureModifier maps = modifier.withTarget(protocol).withType(Map.class);
            serverMaps.add(maps.read(0));
            clientMaps.add(maps.read(1));
        }
        for (Map map : Iterables.concat((Iterable)serverMaps, (Iterable)clientMaps)) {
            result.containers.add(new MapContainer(map));
        }
        if (this.sum(clientMaps) > this.sum(serverMaps)) {
            ArrayList temp = serverMaps;
            serverMaps = clientMaps;
            clientMaps = temp;
        }
        for (int i = 0; i < protocols.length; ++i) {
            Enum enumProtocol = (Enum)protocols[i];
            PacketType.Protocol equivalent = PacketType.Protocol.fromVanilla(enumProtocol);
            this.associatePackets(result, (Map)serverMaps.get(i), equivalent, PacketType.Sender.SERVER);
            this.associatePackets(result, (Map)clientMaps.get(i), equivalent, PacketType.Sender.CLIENT);
        }
        this.register = result;
    }

    private void associatePackets(Register register, Map<Integer, Class<?>> lookup, PacketType.Protocol protocol, PacketType.Sender sender) {
        for (Map.Entry<Integer, Class<?>> entry : lookup.entrySet()) {
            PacketType type = PacketType.fromCurrent(protocol, sender, entry.getKey(), -1);
            register.typeToClass.put((Object)type, entry.getValue());
            if (sender == PacketType.Sender.SERVER) {
                register.serverPackets.add(type);
            }
            if (sender != PacketType.Sender.CLIENT) continue;
            register.clientPackets.add(type);
        }
    }

    private int sum(Iterable<? extends Map<Integer, Class<?>>> maps) {
        int count = 0;
        for (Map<Integer, Class<?>> map : maps) {
            count += map.size();
        }
        return count;
    }

    private static class Register {
        public BiMap<PacketType, Class<?>> typeToClass = HashBiMap.create();
        public volatile Set<PacketType> serverPackets = Sets.newHashSet();
        public volatile Set<PacketType> clientPackets = Sets.newHashSet();
        public List<MapContainer> containers = Lists.newArrayList();

        private Register() {
        }

        public boolean isOutdated() {
            for (MapContainer container : this.containers) {
                if (!container.hasChanged()) continue;
                return true;
            }
            return false;
        }
    }
}

