/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.compiler.BackgroundCompiler;
import com.comphenix.protocol.reflect.compiler.CompileListener;
import com.comphenix.protocol.reflect.compiler.CompiledStructureModifier;
import com.comphenix.protocol.reflect.instances.DefaultInstances;
import com.comphenix.protocol.utility.MinecraftReflection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class StructureCache {
    private static ConcurrentMap<PacketType, StructureModifier<Object>> structureModifiers = new ConcurrentHashMap<PacketType, StructureModifier<Object>>();
    private static Set<PacketType> compiling = new HashSet<PacketType>();

    @Deprecated
    public static Object newPacket(int legacyId) {
        return StructureCache.newPacket(PacketType.findLegacy(legacyId));
    }

    public static Object newPacket(PacketType type) {
        Object result;
        Class clazz = PacketRegistry.getPacketClassFromType(type, true);
        if (clazz != null && (result = DefaultInstances.DEFAULT.create(clazz)) != null) {
            return result;
        }
        throw new IllegalArgumentException("Cannot find associated packet class: " + type);
    }

    @Deprecated
    public static StructureModifier<Object> getStructure(int legacyId) {
        return StructureCache.getStructure(PacketType.findLegacy(legacyId));
    }

    public static StructureModifier<Object> getStructure(PacketType type) {
        return StructureCache.getStructure(type, true);
    }

    public static StructureModifier<Object> getStructure(Class<?> packetType) {
        return StructureCache.getStructure(packetType, true);
    }

    public static StructureModifier<Object> getStructure(Class<?> packetType, boolean compile) {
        return StructureCache.getStructure(PacketRegistry.getPacketType(packetType), compile);
    }

    @Deprecated
    public static StructureModifier<Object> getStructure(int legacyId, boolean compile) {
        return StructureCache.getStructure(PacketType.findLegacy(legacyId), compile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructureModifier<Object> getStructure(final PacketType type, boolean compile) {
        StructureModifier value;
        StructureModifier result = (StructureModifier)structureModifiers.get(type);
        if (result == null && (result = structureModifiers.putIfAbsent(type, value = new StructureModifier(PacketRegistry.getPacketClassFromType(type, true), MinecraftReflection.getPacketClass(), true))) == null) {
            result = value;
        }
        if (compile && !(result instanceof CompiledStructureModifier)) {
            Set<PacketType> set = compiling;
            synchronized (set) {
                BackgroundCompiler compiler = BackgroundCompiler.getInstance();
                if (!compiling.contains(type) && compiler != null) {
                    compiler.scheduleCompilation(result, new CompileListener<Object>(){

                        @Override
                        public void onCompiled(StructureModifier<Object> compiledModifier) {
                            structureModifiers.put(type, compiledModifier);
                        }
                    });
                    compiling.add(type);
                }
            }
        }
        return result;
    }
}

