/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.async;

import com.comphenix.protocol.AsynchronousManager;
import com.comphenix.protocol.PacketStream;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.async.AsyncListenerHandler;
import com.comphenix.protocol.async.AsyncMarker;
import com.comphenix.protocol.async.NullPacketListener;
import com.comphenix.protocol.async.PacketProcessingQueue;
import com.comphenix.protocol.async.PacketSendingQueue;
import com.comphenix.protocol.async.PlayerSendingHandler;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.events.ListeningWhitelist;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.injector.PacketFilterManager;
import com.comphenix.protocol.injector.PrioritizedListener;
import com.comphenix.protocol.injector.SortedPacketListenerList;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class AsyncFilterManager
implements AsynchronousManager {
    private SortedPacketListenerList serverTimeoutListeners;
    private SortedPacketListenerList clientTimeoutListeners;
    private Set<PacketListener> timeoutListeners;
    private PacketProcessingQueue serverProcessingQueue;
    private PacketProcessingQueue clientProcessingQueue;
    private final PlayerSendingHandler playerSendingHandler;
    private final ErrorReporter reporter;
    private final Thread mainThread;
    private final BukkitScheduler scheduler;
    private final AtomicInteger currentSendingIndex = new AtomicInteger();
    private ProtocolManager manager;

    public AsyncFilterManager(ErrorReporter reporter, BukkitScheduler scheduler) {
        this.serverTimeoutListeners = new SortedPacketListenerList();
        this.clientTimeoutListeners = new SortedPacketListenerList();
        this.timeoutListeners = Sets.newSetFromMap(new ConcurrentHashMap());
        this.playerSendingHandler = new PlayerSendingHandler(reporter, this.serverTimeoutListeners, this.clientTimeoutListeners);
        this.serverProcessingQueue = new PacketProcessingQueue(this.playerSendingHandler);
        this.clientProcessingQueue = new PacketProcessingQueue(this.playerSendingHandler);
        this.playerSendingHandler.initializeScheduler();
        this.scheduler = scheduler;
        this.reporter = reporter;
        this.mainThread = Thread.currentThread();
    }

    public ProtocolManager getManager() {
        return this.manager;
    }

    public void setManager(ProtocolManager manager) {
        this.manager = manager;
    }

    @Override
    public AsyncListenerHandler registerAsyncHandler(PacketListener listener) {
        return this.registerAsyncHandler(listener, true);
    }

    @Override
    public void registerTimeoutHandler(PacketListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be NULL.");
        }
        if (!this.timeoutListeners.add(listener)) {
            return;
        }
        ListeningWhitelist sending = listener.getSendingWhitelist();
        ListeningWhitelist receiving = listener.getReceivingWhitelist();
        if (!ListeningWhitelist.isEmpty(sending)) {
            this.serverTimeoutListeners.addListener(listener, sending);
        }
        if (!ListeningWhitelist.isEmpty(receiving)) {
            this.serverTimeoutListeners.addListener(listener, receiving);
        }
    }

    @Override
    public Set<PacketListener> getTimeoutHandlers() {
        return ImmutableSet.copyOf(this.timeoutListeners);
    }

    @Override
    public Set<PacketListener> getAsyncHandlers() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (PrioritizedListener handler : Iterables.concat(this.serverProcessingQueue.values(), this.clientProcessingQueue.values())) {
            builder.add((Object)((AsyncListenerHandler)handler.getListener()).getAsyncListener());
        }
        return builder.build();
    }

    public AsyncListenerHandler registerAsyncHandler(PacketListener listener, boolean autoInject) {
        AsyncListenerHandler handler = new AsyncListenerHandler(this.mainThread, this, listener);
        ListeningWhitelist sendingWhitelist = listener.getSendingWhitelist();
        ListeningWhitelist receivingWhitelist = listener.getReceivingWhitelist();
        if (!this.hasValidWhitelist(sendingWhitelist) && !this.hasValidWhitelist(receivingWhitelist)) {
            throw new IllegalArgumentException("Listener has an empty sending and receiving whitelist.");
        }
        if (this.hasValidWhitelist(sendingWhitelist)) {
            PacketFilterManager.verifyWhitelist(listener, sendingWhitelist);
            this.serverProcessingQueue.addListener(handler, sendingWhitelist);
        }
        if (this.hasValidWhitelist(receivingWhitelist)) {
            PacketFilterManager.verifyWhitelist(listener, receivingWhitelist);
            this.clientProcessingQueue.addListener(handler, receivingWhitelist);
        }
        if (autoInject) {
            handler.setNullPacketListener(new NullPacketListener(listener));
            this.manager.addPacketListener(handler.getNullPacketListener());
        }
        return handler;
    }

    private boolean hasValidWhitelist(ListeningWhitelist whitelist) {
        return whitelist != null && whitelist.getTypes().size() > 0;
    }

    @Override
    public void unregisterTimeoutHandler(PacketListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be NULL.");
        }
        ListeningWhitelist sending = listener.getSendingWhitelist();
        ListeningWhitelist receiving = listener.getReceivingWhitelist();
        if (this.serverTimeoutListeners.removeListener(listener, sending).size() > 0 || this.clientTimeoutListeners.removeListener(listener, receiving).size() > 0) {
            this.timeoutListeners.remove(listener);
        }
    }

    @Override
    public void unregisterAsyncHandler(PacketListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be NULL.");
        }
        AsyncListenerHandler handler = this.findHandler(this.serverProcessingQueue, listener.getSendingWhitelist(), listener);
        if (handler == null) {
            handler = this.findHandler(this.clientProcessingQueue, listener.getReceivingWhitelist(), listener);
        }
        this.unregisterAsyncHandler(handler);
    }

    private AsyncListenerHandler findHandler(PacketProcessingQueue queue, ListeningWhitelist search, PacketListener target) {
        if (ListeningWhitelist.isEmpty(search)) {
            return null;
        }
        for (PacketType type : search.getTypes()) {
            for (PrioritizedListener element : queue.getListener(type)) {
                if (((AsyncListenerHandler)element.getListener()).getAsyncListener() != target) continue;
                return (AsyncListenerHandler)element.getListener();
            }
        }
        return null;
    }

    @Override
    public void unregisterAsyncHandler(AsyncListenerHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("listenerToken cannot be NULL");
        }
        handler.cancel();
    }

    void unregisterAsyncHandlerInternal(AsyncListenerHandler handler) {
        List<PacketType> removed;
        PacketListener listener = handler.getAsyncListener();
        boolean synchronusOK = this.onMainThread();
        if (handler.getNullPacketListener() != null) {
            this.manager.removePacketListener(handler.getNullPacketListener());
        }
        if (this.hasValidWhitelist(listener.getSendingWhitelist())) {
            removed = this.serverProcessingQueue.removeListener(handler, listener.getSendingWhitelist());
            this.playerSendingHandler.sendServerPackets(removed, synchronusOK);
        }
        if (this.hasValidWhitelist(listener.getReceivingWhitelist())) {
            removed = this.clientProcessingQueue.removeListener(handler, listener.getReceivingWhitelist());
            this.playerSendingHandler.sendClientPackets(removed, synchronusOK);
        }
    }

    private boolean onMainThread() {
        return Thread.currentThread().getId() == this.mainThread.getId();
    }

    @Override
    public void unregisterAsyncHandlers(Plugin plugin) {
        this.unregisterAsyncHandlers(this.serverProcessingQueue, plugin);
        this.unregisterAsyncHandlers(this.clientProcessingQueue, plugin);
    }

    private void unregisterAsyncHandlers(PacketProcessingQueue processingQueue, Plugin plugin) {
        for (PrioritizedListener listener : processingQueue.values()) {
            if (!Objects.equal((Object)((AsyncListenerHandler)listener.getListener()).getPlugin(), (Object)plugin)) continue;
            this.unregisterAsyncHandler((AsyncListenerHandler)listener.getListener());
        }
    }

    public synchronized void enqueueSyncPacket(PacketEvent syncPacket, AsyncMarker asyncMarker) {
        PacketEvent newEvent = PacketEvent.fromSynchronous(syncPacket, asyncMarker);
        if (asyncMarker.isQueued() || asyncMarker.isTransmitted()) {
            throw new IllegalArgumentException("Cannot queue a packet that has already been queued.");
        }
        asyncMarker.setQueuedSendingIndex(asyncMarker.getNewSendingIndex());
        this.getSendingQueue(syncPacket).enqueue(newEvent);
        this.getProcessingQueue(syncPacket).enqueue(newEvent, true);
    }

    @Override
    public Set<Integer> getSendingFilters() {
        return PacketRegistry.toLegacy(this.serverProcessingQueue.keySet());
    }

    @Override
    public Set<PacketType> getReceivingTypes() {
        return this.serverProcessingQueue.keySet();
    }

    @Override
    public Set<Integer> getReceivingFilters() {
        return PacketRegistry.toLegacy(this.clientProcessingQueue.keySet());
    }

    @Override
    public Set<PacketType> getSendingTypes() {
        return this.clientProcessingQueue.keySet();
    }

    public BukkitScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public boolean hasAsynchronousListeners(PacketEvent packet) {
        Collection list = this.getProcessingQueue(packet).getListener(packet.getPacketType());
        return list != null && list.size() > 0;
    }

    public AsyncMarker createAsyncMarker() {
        return this.createAsyncMarker(0L, 1800000L);
    }

    public AsyncMarker createAsyncMarker(long sendingDelta, long timeoutDelta) {
        return this.createAsyncMarker(sendingDelta, timeoutDelta, this.currentSendingIndex.incrementAndGet(), System.currentTimeMillis());
    }

    private AsyncMarker createAsyncMarker(long sendingDelta, long timeoutDelta, long sendingIndex, long currentTime) {
        return new AsyncMarker(this.manager, sendingIndex, sendingDelta, System.currentTimeMillis(), timeoutDelta);
    }

    @Override
    public PacketStream getPacketStream() {
        return this.manager;
    }

    @Override
    public ErrorReporter getErrorReporter() {
        return this.reporter;
    }

    @Override
    public void cleanupAll() {
        this.serverProcessingQueue.cleanupAll();
        this.playerSendingHandler.cleanupAll();
        this.timeoutListeners.clear();
        this.serverTimeoutListeners = null;
        this.clientTimeoutListeners = null;
    }

    @Override
    public void signalPacketTransmission(PacketEvent packet) {
        this.signalPacketTransmission(packet, this.onMainThread());
    }

    private void signalPacketTransmission(PacketEvent packet, boolean onMainThread) {
        PacketSendingQueue queue;
        AsyncMarker marker = packet.getAsyncMarker();
        if (marker == null) {
            throw new IllegalArgumentException("A sync packet cannot be transmitted by the asynchronous manager.");
        }
        if (!marker.isQueued()) {
            throw new IllegalArgumentException("A packet must have been queued before it can be transmitted.");
        }
        if (marker.decrementProcessingDelay() == 0 && (queue = this.getSendingQueue(packet, false)) != null) {
            queue.signalPacketUpdate(packet, onMainThread);
        }
    }

    public PacketSendingQueue getSendingQueue(PacketEvent packet) {
        return this.playerSendingHandler.getSendingQueue(packet);
    }

    public PacketSendingQueue getSendingQueue(PacketEvent packet, boolean createNew) {
        return this.playerSendingHandler.getSendingQueue(packet, createNew);
    }

    public PacketProcessingQueue getProcessingQueue(PacketEvent packet) {
        return packet.isServerPacket() ? this.serverProcessingQueue : this.clientProcessingQueue;
    }

    public void signalFreeProcessingSlot(PacketEvent packet) {
        this.getProcessingQueue(packet).signalProcessingDone();
    }

    public void sendProcessedPackets(int tickCounter, boolean onMainThread) {
        if (tickCounter % 10 == 0) {
            this.playerSendingHandler.trySendServerPackets(onMainThread);
        }
        this.playerSendingHandler.trySendClientPackets(onMainThread);
    }

    public void removePlayer(Player player) {
        this.playerSendingHandler.removePlayer(player);
    }
}

