/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.protocol.CommandBase;
import com.comphenix.protocol.ProtocolConfig;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.timing.TimedListenerManager;
import com.comphenix.protocol.timing.TimingReportGenerator;
import java.io.File;
import java.io.IOException;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

class CommandProtocol
extends CommandBase {
    public static final String NAME = "protocol";
    private Plugin plugin;
    private ProtocolConfig config;

    public CommandProtocol(ErrorReporter reporter, Plugin plugin, ProtocolConfig config) {
        super(reporter, "protocol.admin", NAME, 1);
        this.plugin = plugin;
        this.config = config;
    }

    @Override
    protected boolean handleCommand(CommandSender sender, String[] args) {
        String subCommand = args[0];
        if (subCommand.equalsIgnoreCase("config") || subCommand.equalsIgnoreCase("reload")) {
            this.reloadConfiguration(sender);
        } else if (subCommand.equalsIgnoreCase("timings")) {
            this.toggleTimings(sender, args);
        } else if (subCommand.equalsIgnoreCase("listeners")) {
            this.printListeners(sender, args);
        } else {
            return false;
        }
        return true;
    }

    private void printListeners(CommandSender sender, String[] args) {
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        for (PacketListener listener : manager.getPacketListeners()) {
            sender.sendMessage(ChatColor.GOLD + "Packet listeners:");
            sender.sendMessage(ChatColor.GOLD + " " + listener);
        }
        for (PacketListener listener : manager.getAsynchronousManager().getAsyncHandlers()) {
            sender.sendMessage(ChatColor.GOLD + "Asynchronous listeners:");
            sender.sendMessage(ChatColor.GOLD + " " + listener);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void toggleTimings(CommandSender sender, String[] args) {
        boolean state;
        TimedListenerManager manager = TimedListenerManager.getInstance();
        boolean bl = state = !manager.isTiming();
        if (args.length == 2) {
            Boolean parsed = this.parseBoolean(this.toQueue(args, 2), "start");
            if (parsed == null) {
                sender.sendMessage(ChatColor.RED + "Specify a state: ON or OFF.");
                return;
            }
            state = parsed;
        } else if (args.length > 2) {
            sender.sendMessage(ChatColor.RED + "Too many parameters.");
            return;
        }
        if (state) {
            if (manager.startTiming()) {
                sender.sendMessage(ChatColor.GOLD + "Started timing packet listeners.");
                return;
            }
            sender.sendMessage(ChatColor.RED + "Packet timing already started.");
            return;
        }
        if (manager.stopTiming()) {
            this.saveTimings(manager);
            sender.sendMessage(ChatColor.GOLD + "Stopped and saved result in plugin folder.");
            return;
        }
        sender.sendMessage(ChatColor.RED + "Packet timing already stopped.");
    }

    private void saveTimings(TimedListenerManager manager) {
        try {
            File destination = new File(this.plugin.getDataFolder(), "Timings - " + System.currentTimeMillis() + ".txt");
            TimingReportGenerator generator = new TimingReportGenerator();
            generator.saveTo(destination, manager);
            manager.clear();
        }
        catch (IOException e) {
            this.reporter.reportMinimal(this.plugin, "saveTimings()", e);
        }
    }

    public void updateFinished() {
        long currentTime = System.currentTimeMillis() / 1000L;
        this.config.setAutoLastTime(currentTime);
        this.config.saveAll();
    }

    public void reloadConfiguration(CommandSender sender) {
        this.plugin.reloadConfig();
        sender.sendMessage(ChatColor.YELLOW + "Reloaded configuration!");
    }
}

