/*
 * Decompiled with CFR 0.152.
 */
package JinRyuu.JRMCore.mixin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.SkinManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={SkinManager.class}, remap=false)
public class MixinSkinManager {
    @Redirect(method={"func_152790_a"}, at=@At(value="INVOKE", target="Lcom/mojang/authlib/minecraft/MinecraftSessionService;getTextures(Lcom/mojang/authlib/GameProfile;Z)Ljava/util/Map;"))
    private Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> redirectGetTextures(MinecraftSessionService svc, GameProfile profile, boolean requireSecure) {
        System.out.println("Modifcando");
        Map result = svc.getTextures(profile, requireSecure);
        if (result != null && !result.isEmpty()) {
            return result;
        }
        try {
            String uuid = profile.getId().toString().replace("-", "");
            URL u = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false");
            HttpURLConnection c = (HttpURLConnection)u.openConnection();
            c.setConnectTimeout(3000);
            c.setReadTimeout(3000);
            if (c.getResponseCode() / 100 == 2) {
                InputStreamReader r = new InputStreamReader(c.getInputStream(), StandardCharsets.UTF_8);
                JsonObject root = new JsonParser().parse((Reader)r).getAsJsonObject();
                JsonArray props = root.getAsJsonArray("properties");
                for (JsonElement pe : props) {
                    String url;
                    JsonObject prop = pe.getAsJsonObject();
                    if (!"textures".equals(prop.get("name").getAsString())) continue;
                    String valueB64 = prop.get("value").getAsString();
                    String json = new String(Base64.getDecoder().decode(valueB64), StandardCharsets.UTF_8);
                    JsonObject textures = new JsonParser().parse(json).getAsJsonObject().getAsJsonObject("textures");
                    HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture> map = new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
                    if (textures.has("SKIN")) {
                        JsonObject skin = textures.getAsJsonObject("SKIN");
                        url = skin.get("url").getAsString();
                        map.put(MinecraftProfileTexture.Type.SKIN, new MinecraftProfileTexture(url, null));
                    }
                    if (textures.has("CAPE")) {
                        JsonObject cape = textures.getAsJsonObject("CAPE");
                        url = cape.get("url").getAsString();
                        map.put(MinecraftProfileTexture.Type.CAPE, new MinecraftProfileTexture(url, null));
                    }
                    return map;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyMap();
    }
}

