/*
 * Decompiled with CFR 0.152.
 */
package JinRyuu.JRMCore.dmg;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class Nfm {
    private static final String[] SUFFIXES_SHORT = new String[]{"", "K", "M", "B", "T", "Qa", "Qi", "Sx", "Sp", "Oc", "No", "Dc", "Ud"};
    private static final String[] SUFFIXES_PT_FULL = new String[]{"", "mil", "milh\ufffdo", "bilh\ufffdo", "trilh\ufffdo", "quadrilh\ufffdo", "quintilh\ufffdo", "sextilh\ufffdo", "septilh\ufffdo", "octilh\ufffdo", "nonilh\ufffdo", "decilh\ufffdo", "undecilh\ufffdo"};
    private static final int MAX_INDEX = SUFFIXES_SHORT.length - 1;
    private static final String[] SUFIXOS = new String[]{"", "K", "M", "B", "T", "Qa", "Qi", "Sx", "Sp", "Oc", "No", "Dc", "Ud"};

    public static String format(double valor) {
        int idx;
        if (Double.isNaN(valor)) {
            return "NaN";
        }
        if (Double.isInfinite(valor)) {
            return valor > 0.0 ? "?" : "-?";
        }
        boolean neg = valor < 0.0;
        double absDouble = Math.abs(valor);
        if (absDouble == 0.0) {
            return "0";
        }
        BigDecimal bd = BigDecimal.valueOf(absDouble);
        BigDecimal thousand = BigDecimal.valueOf(1000L);
        for (idx = 0; bd.compareTo(thousand) >= 0 && idx < SUFIXOS.length - 1; ++idx) {
            bd = bd.divide(thousand, 12, RoundingMode.HALF_UP);
        }
        bd = bd.setScale(2, RoundingMode.HALF_UP).stripTrailingZeros();
        String num = bd.toPlainString();
        if (idx == 0 && num.indexOf(46) >= 0 && num.endsWith(".0")) {
            num = num.substring(0, num.length() - 2);
        }
        return (neg ? "-" : "") + num + SUFIXOS[idx];
    }

    public static String format(double value, int maxDecimals, boolean useShortSuffix) {
        return Nfm.format(BigDecimal.valueOf(value), maxDecimals, useShortSuffix);
    }

    public static String format(BigDecimal number) {
        int index;
        String[] suffixes = new String[]{"", "K", "M", "B", "T", "Q", "Qi", "Sx", "Sp", "Oc", "No", "Dc"};
        BigDecimal thousand = new BigDecimal("1000");
        BigDecimal temp = number;
        for (index = 0; temp.compareTo(thousand) >= 0 && index < suffixes.length - 1; ++index) {
            temp = temp.divide(thousand, 2, 4);
        }
        BigDecimal divisor = thousand.pow(index);
        BigDecimal scaled = number.divide(divisor, 2, 4);
        String formatted = scaled.stripTrailingZeros().toPlainString();
        return formatted + suffixes[index];
    }

    public static String format(BigDecimal number, int maxDecimals, boolean useShortSuffix) {
        int index;
        if (number == null) {
            return "null";
        }
        if (number.compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        boolean negative = number.signum() < 0;
        BigDecimal v = number.abs();
        BigDecimal thousand = BigDecimal.valueOf(1000L);
        for (index = 0; v.compareTo(thousand) >= 0 && index < MAX_INDEX; ++index) {
            v = v.divide(thousand, maxDecimals + 4, RoundingMode.HALF_UP);
        }
        if (v.compareTo(thousand) >= 0 && index == MAX_INDEX) {
            String sci = number.stripTrailingZeros().toEngineeringString();
            return negative ? "-" + sci : sci;
        }
        int decimalsToShow = v.compareTo(BigDecimal.valueOf(100L)) >= 0 ? 0 : (v.compareTo(BigDecimal.valueOf(10L)) >= 0 ? Math.min(1, maxDecimals) : Math.min(2, maxDecimals));
        v = v.setScale(decimalsToShow, RoundingMode.HALF_UP).stripTrailingZeros();
        String formattedNumber = v.toPlainString();
        String suffix = useShortSuffix ? SUFFIXES_SHORT[index] : " " + SUFFIXES_PT_FULL[index];
        return (negative ? "-" : "") + formattedNumber + suffix;
    }

    public static void main(String[] args) {
        System.out.println(Nfm.format(123.0));
        System.out.println(Nfm.format(1234.0));
        System.out.println(Nfm.format(1234567.0));
        System.out.println(Nfm.format(1.23456789E9));
        System.out.println(Nfm.format(1.0E15));
        System.out.println(Nfm.format(1.0E18));
        System.out.println(Nfm.format(1.0E30));
        System.out.println(Nfm.format(BigDecimal.TEN.pow(36), 2, true));
        System.out.println(Nfm.format(3.4028234663852886E38));
    }
}

