/*
 * Decompiled with CFR 0.152.
 */
package JinRyuu.JRMCore.after.nv;

import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.entity.Entity;

public final class ReflectionEntityUtils {
    private static Field cachedUuidField = null;

    private ReflectionEntityUtils() {
    }

    public static void setEntityUUID(Entity entity, UUID newUuid) {
        if (entity == null || newUuid == null) {
            return;
        }
        try {
            Field f = ReflectionEntityUtils.getUuidField(entity.getClass());
            f.set(entity, newUuid);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static Field getUuidField(Class<?> clazz) throws NoSuchFieldException {
        if (cachedUuidField != null) {
            return cachedUuidField;
        }
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                for (Field f : c.getDeclaredFields()) {
                    if (f.getType() != UUID.class) continue;
                    f.setAccessible(true);
                    cachedUuidField = f;
                    return f;
                }
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            Field f = Entity.class.getDeclaredField("entityUniqueID");
            f.setAccessible(true);
            cachedUuidField = f;
            return f;
        }
        catch (Throwable f) {
            try {
                Field f2 = Entity.class.getDeclaredField("field_110155_d");
                f2.setAccessible(true);
                cachedUuidField = f2;
                return f2;
            }
            catch (Throwable throwable) {
                throw new NoSuchFieldException("Campo UUID da Entity n\ufffdo encontrado (entityUniqueID).");
            }
        }
    }
}

