/*
 * Decompiled with CFR 0.152.
 */
package JinRyuu.JRMCore.after.nv;

import JinRyuu.JRMCore.after.nv.ServerLogic;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import noppes.npcs.entity.EntityCustomNpc;

public class PacketMinionRefactor
implements IMessage {
    public static final ConcurrentHashMap<UUID, EntityCustomNpc> manipulables = new ConcurrentHashMap();
    private static final AtomicInteger CLIENT_ID_GENERATOR = new AtomicInteger(-100000);
    public EnumSet<Flag> flags = EnumSet.of(Flag.NONE);
    public UUID uuid;
    public String name;
    public double x;
    public double y;
    public double z;
    public float pitch;
    public float yaw;
    public int modelSize;
    public String url;
    public String modelClass;
    public String texture;
    public boolean isclickleft = false;
    public String description;
    private EntityCustomNpc npc;
    public static Random random = new Random();

    public static UUID fromEntity(Entity entity) {
        for (Map.Entry<UUID, EntityCustomNpc> value : manipulables.entrySet()) {
            if (!entity.func_70028_i((Entity)value.getValue())) continue;
            return value.getKey();
        }
        return null;
    }

    private static void writeOptionalString(ByteBuf buf, String s) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(s == null ? "" : s));
    }

    private static String readOptionalString(ByteBuf buf) {
        String s = ByteBufUtils.readUTF8String((ByteBuf)buf);
        return s == null || s.isEmpty() ? null : s;
    }

    private int flagsToMask() {
        int m = 0;
        for (Flag f : this.flags) {
            m |= 1 << f.ordinal();
        }
        return m;
    }

    private static EnumSet<Flag> maskToFlags(int mask) {
        EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
        for (Flag f : Flag.values()) {
            if ((mask & 1 << f.ordinal()) == 0) continue;
            set.add(f);
        }
        return set;
    }

    public void toBytes(ByteBuf buf) {
        PacketMinionRefactor.writeOptionalString(buf, this.uuid == null ? "" : this.uuid.toString());
        buf.writeInt(this.flagsToMask());
        boolean all = this.flags.contains((Object)Flag.ALL);
        if (all || this.flags.contains((Object)Flag.NAME)) {
            PacketMinionRefactor.writeOptionalString(buf, this.name);
        }
        if (all || this.flags.contains((Object)Flag.XYZ)) {
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
        }
        if (all || this.flags.contains((Object)Flag.ROT)) {
            buf.writeFloat(this.pitch);
            buf.writeFloat(this.yaw);
        }
        if (all || this.flags.contains((Object)Flag.MODEL_SIZE)) {
            buf.writeInt(this.modelSize);
        }
        if (all || this.flags.contains((Object)Flag.URL)) {
            PacketMinionRefactor.writeOptionalString(buf, this.url);
        }
        if (all || this.flags.contains((Object)Flag.MODEL_CLASS)) {
            PacketMinionRefactor.writeOptionalString(buf, this.modelClass);
        }
        if (all || this.flags.contains((Object)Flag.TEXTURE)) {
            PacketMinionRefactor.writeOptionalString(buf, this.texture);
        }
        if (all || this.flags.contains((Object)Flag.EVENT_CLICK)) {
            buf.writeBoolean(this.isclickleft);
        }
        if (all || this.flags.contains((Object)Flag.DESCRIPTION)) {
            PacketMinionRefactor.writeOptionalString(buf, this.description);
        }
    }

    public void fromBytes(ByteBuf buf) {
        String uuidStr = PacketMinionRefactor.readOptionalString(buf);
        this.uuid = uuidStr == null ? null : UUID.fromString(uuidStr);
        int mask = buf.readInt();
        this.flags = PacketMinionRefactor.maskToFlags(mask);
        boolean all = this.flags.contains((Object)Flag.ALL);
        if (all || this.flags.contains((Object)Flag.NAME)) {
            this.name = PacketMinionRefactor.readOptionalString(buf);
        }
        if (all || this.flags.contains((Object)Flag.XYZ)) {
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
        }
        if (all || this.flags.contains((Object)Flag.ROT)) {
            this.pitch = buf.readFloat();
            this.yaw = buf.readFloat();
        }
        if (all || this.flags.contains((Object)Flag.MODEL_SIZE)) {
            this.modelSize = buf.readInt();
        }
        if (all || this.flags.contains((Object)Flag.URL)) {
            this.url = PacketMinionRefactor.readOptionalString(buf);
        }
        if (all || this.flags.contains((Object)Flag.MODEL_CLASS)) {
            this.modelClass = PacketMinionRefactor.readOptionalString(buf);
        }
        if (all || this.flags.contains((Object)Flag.TEXTURE)) {
            this.texture = PacketMinionRefactor.readOptionalString(buf);
        }
        if (all || this.flags.contains((Object)Flag.EVENT_CLICK)) {
            this.isclickleft = buf.readBoolean();
        }
        if (all || this.flags.contains((Object)Flag.DESCRIPTION)) {
            this.description = PacketMinionRefactor.readOptionalString(buf);
        }
    }

    public static boolean exist(UUID id) {
        return manipulables.containsKey(id);
    }

    public static EntityCustomNpc get(UUID id) {
        if (id == null) {
            return null;
        }
        return manipulables.get(id);
    }

    public static void delete(UUID id) {
        EntityCustomNpc e = manipulables.remove(id);
        if (e != null) {
            try {
                e.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void deleteAll() {
        for (EntityCustomNpc e : manipulables.values()) {
            try {
                e.delete();
            }
            catch (Exception exception) {}
        }
        manipulables.clear();
    }

    public static void defineName(UUID id, String name) {
        EntityCustomNpc e = PacketMinionRefactor.get(id);
        if (e != null && name != null) {
            e.display.name = name;
        }
    }

    public static void defineDescription(UUID id, String description) {
        EntityCustomNpc e = PacketMinionRefactor.get(id);
        if (e != null && description != null) {
            e.display.title = description;
        }
    }

    public void treat(EntityCustomNpc npc) {
        boolean all = this.flags.contains((Object)Flag.ALL);
        if ((all || this.flags.contains((Object)Flag.DESCRIPTION)) && this.description != null) {
            npc.display.title = this.description;
            npc.script.clientNeedsUpdate = true;
        }
        if ((all || this.flags.contains((Object)Flag.NAME)) && this.name != null) {
            npc.display.name = this.name;
            npc.script.clientNeedsUpdate = true;
        }
        if ((all || this.flags.contains((Object)Flag.MODEL_CLASS)) && this.modelClass != null) {
            npc.modelData.setEntity(this.modelClass);
        }
        if ((all || this.flags.contains((Object)Flag.TEXTURE)) && this.texture != null) {
            npc.display.setSkinTexture(this.texture);
        }
        if ((all || this.flags.contains((Object)Flag.URL)) && this.url != null) {
            npc.display.url = this.url;
            npc.textureLocation = null;
            npc.display.skinType = (byte)2;
            npc.script.clientNeedsUpdate = true;
        }
    }

    public static void teleport(UUID id, PacketMinionRefactor msg) {
        EntityCustomNpc e = PacketMinionRefactor.get(id);
        if (e == null) {
            return;
        }
        if (msg.flags.contains((Object)Flag.XYZ)) {
            e.func_70107_b(msg.x, msg.y, msg.z);
        }
        if (msg.flags.contains((Object)Flag.ROT)) {
            e.field_70125_A = msg.pitch;
            e.field_70177_z = msg.yaw;
            e.field_70759_as = msg.yaw;
        }
    }

    public void spawnFromPacket() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null || !world.field_72995_K) {
            return;
        }
        boolean all = this.flags.contains((Object)Flag.ALL);
        try {
            EntityCustomNpc npc = new EntityCustomNpc((World)world);
            if (all || this.flags.contains((Object)Flag.XYZ)) {
                npc.func_70107_b(this.x, this.y, this.z);
            }
            if (all || this.flags.contains((Object)Flag.ROT)) {
                npc.field_70177_z = this.yaw;
                npc.field_70125_A = this.pitch;
                npc.field_70759_as = this.yaw;
            }
            npc.display.modelSize = this.modelSize <= 0 ? 5 : this.modelSize;
            npc.field_70131_O = (float)npc.display.modelSize * 2.0f / 5.0f;
            this.treat(npc);
            int clientId = CLIENT_ID_GENERATOR.getAndDecrement() - random.nextInt(1000);
            world.func_73027_a(clientId, (Entity)npc);
            manipulables.put(this.uuid, npc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Handler
    implements IMessageHandler<PacketMinionRefactor, IMessage> {
        public IMessage onMessage(PacketMinionRefactor msg, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                ServerLogic.treat(msg, ctx);
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> {
                try {
                    if (msg.flags.contains((Object)Flag.DELETE_ALL)) {
                        PacketMinionRefactor.deleteAll();
                        return;
                    }
                    if (msg.flags.contains((Object)Flag.SPAWN) && !PacketMinionRefactor.exist(msg.uuid)) {
                        msg.spawnFromPacket();
                        return;
                    }
                    EntityCustomNpc e = PacketMinionRefactor.get(msg.uuid);
                    if (e == null) {
                        return;
                    }
                    boolean all = msg.flags.contains((Object)Flag.ALL);
                    if (all || msg.flags.contains((Object)Flag.DELETE)) {
                        PacketMinionRefactor.delete(msg.uuid);
                    }
                    if (all || msg.flags.contains((Object)Flag.NAME)) {
                        PacketMinionRefactor.defineName(msg.uuid, msg.name);
                    }
                    if (all || msg.flags.contains((Object)Flag.DESCRIPTION)) {
                        PacketMinionRefactor.defineDescription(msg.uuid, msg.name);
                    }
                    if (all || msg.flags.contains((Object)Flag.TP)) {
                        PacketMinionRefactor.teleport(msg.uuid, msg);
                    }
                    msg.treat(e);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            return null;
        }
    }

    public static enum Flag {
        ALL,
        NAME,
        XYZ,
        ROT,
        MODEL_SIZE,
        URL,
        MODEL_CLASS,
        TEXTURE,
        SPAWN,
        DELETE,
        DELETE_ALL,
        TP,
        NONE,
        EVENT_CLICK,
        DESCRIPTION;

    }
}

