/*
 * Decompiled with CFR 0.152.
 */
package JinRyuu.JRMCore.after;

import JinRyuu.JRMCore.p.PD;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class PacketModel
implements IMessage {
    public static ConcurrentHashMap<String, Model> playersAndModels = new ConcurrentHashMap();
    private HashMap<String, Model> models;

    public static Model fromPlayer(EntityPlayer entityPlayer) {
        if (entityPlayer == null) {
            return null;
        }
        return playersAndModels.get(entityPlayer.func_70005_c_().toLowerCase());
    }

    public static Model fromPlayer(String playerName) {
        if (playerName == null) {
            return null;
        }
        return playersAndModels.get(playerName.toLowerCase());
    }

    public PacketModel() {
    }

    public PacketModel(HashMap<String, Model> models) {
        this.models = models;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.models.size());
        for (Model m : this.models.values()) {
            m.toBytes(buf);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.models = new HashMap();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            Model m = Model.fromBytes(buf);
            this.models.put(m.getPlayerName(), m);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketModel, IMessage> {
        public IMessage onMessage(PacketModel message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                playersAndModels.putAll(message.models);
            }
            return null;
        }
    }

    public static class Model {
        public String playerName;
        public int model;

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.playerName == null ? "" : this.playerName));
            buf.writeInt(this.model);
        }

        public static Model fromBytes(ByteBuf buf) {
            Model m = new Model();
            m.playerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            m.model = buf.readInt();
            return m;
        }

        public int getModel() {
            return this.model;
        }

        public String getPlayerName() {
            return this.playerName;
        }
    }

    public static class ServerModel {
        public static void sendToAll(HashMap<String, Model> map) {
            PD.sendToAll(new PacketModel(map));
        }

        public static void sendTo(String playerName, HashMap<String, Model> map) {
            EntityPlayerMP playerMP = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(playerName);
            if (playerMP != null) {
                PD.sendTo(new PacketModel(map), playerMP);
            }
        }
    }
}

