/*
 * Decompiled with CFR 0.152.
 */
package JinRyuu.JRMCore.after;

import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtList;
import com.comphenix.protocol.wrappers.nbt.NbtWrapper;
import com.comphenix.protocol.wrappers.nbt.io.NbtTextSerializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NbtConverter {
    public static NBTTagCompound convertToForgeNBT(String serializedNbt) {
        try {
            NbtWrapper nbtWrapper = NbtTextSerializer.DEFAULT.deserialize(serializedNbt);
            if (nbtWrapper instanceof NbtCompound) {
                return NbtConverter.convertCompound((NbtCompound)((Object)nbtWrapper));
            }
            throw new IllegalArgumentException("O NBT desserializado n\ufffdo \ufffd um NbtCompound.");
        }
        catch (IOException e) {
            e.printStackTrace();
            return new NBTTagCompound();
        }
    }

    private static NBTTagCompound convertCompound(NbtCompound protocolNbt) {
        NBTTagCompound forgeNbt = new NBTTagCompound();
        for (Map.Entry<String, NbtBase<?>> entry : protocolNbt.getValue().entrySet()) {
            forgeNbt.func_74782_a(entry.getKey(), NbtConverter.convert(entry.getValue()));
        }
        return forgeNbt;
    }

    private static NBTBase convert(NbtBase<?> nbt) {
        switch (nbt.getType()) {
            case TAG_COMPOUND: {
                return NbtConverter.convertCompound((NbtCompound)nbt);
            }
            case TAG_LIST: {
                return NbtConverter.convertList((NbtList)nbt);
            }
            case TAG_STRING: {
                return new NBTTagString(nbt.getValue().toString());
            }
            case TAG_INT: {
                return new NBTTagInt(((Integer)nbt.getValue()).intValue());
            }
            case TAG_DOUBLE: {
                return new NBTTagDouble(((Double)nbt.getValue()).doubleValue());
            }
            case TAG_FLOAT: {
                return new NBTTagFloat(((Float)nbt.getValue()).floatValue());
            }
            case TAG_LONG: {
                return new NBTTagLong(((Long)nbt.getValue()).longValue());
            }
            case TAG_BYTE: {
                return new NBTTagByte(((Byte)nbt.getValue()).byteValue());
            }
            case TAG_SHORT: {
                return new NBTTagShort(((Short)nbt.getValue()).shortValue());
            }
            case TAG_BYTE_ARRAY: {
                return new NBTTagByteArray((byte[])nbt.getValue());
            }
            case TAG_INT_ARRAY: {
                return new NBTTagIntArray((int[])nbt.getValue());
            }
        }
        throw new IllegalArgumentException("Tipo de NBT n\ufffdo suportado: " + (Object)((Object)nbt.getType()));
    }

    private static NBTTagList convertList(NbtList<?> protocolList) {
        NBTTagList forgeList = new NBTTagList();
        Iterator<?> it = protocolList.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            System.out.println(o.getClass());
            if (!(o instanceof NbtBase)) continue;
            forgeList.func_74742_a(NbtConverter.convert((NbtBase)it.next()));
        }
        return forgeList;
    }
}

