/*
 * Decompiled with CFR 0.152.
 */
package JinRyuu.JBRA.bb;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ResourceLocation;

public class RecolorizedTextureManager {
    private static final Map<CacheKey, Integer> textureCache = new HashMap<CacheKey, Integer>();
    private static final float GREEN_DOMINANCE_FACTOR = 1.3f;

    public static int getOrCreateRecoloredTexture(ResourceLocation originalTexture, Color colorForWhite, Color colorForBlack, Color colorForGreen) {
        CacheKey key = new CacheKey(originalTexture, colorForWhite, colorForBlack, colorForGreen);
        if (textureCache.containsKey(key)) {
            return textureCache.get(key);
        }
        try {
            BufferedImage originalImage = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(originalTexture).func_110527_b());
            int width = originalImage.getWidth();
            int height = originalImage.getHeight();
            BufferedImage newImage = new BufferedImage(width, height, 2);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    Color finalColor;
                    Color originalPixel = new Color(originalImage.getRGB(x, y), true);
                    if (originalPixel.getAlpha() < 10) {
                        newImage.setRGB(x, y, originalPixel.getRGB());
                        continue;
                    }
                    float r = (float)originalPixel.getRed() / 255.0f;
                    float g = (float)originalPixel.getGreen() / 255.0f;
                    float b = (float)originalPixel.getBlue() / 255.0f;
                    if (g > r * 1.3f && g > b * 1.3f) {
                        float greenBrightness = g;
                        finalColor = RecolorizedTextureManager.scaleColor(colorForGreen, greenBrightness, originalPixel.getAlpha());
                    } else {
                        float brightness = (r + g + b) / 3.0f;
                        finalColor = RecolorizedTextureManager.lerpColor(colorForBlack, colorForWhite, brightness, originalPixel.getAlpha());
                    }
                    newImage.setRGB(x, y, finalColor.getRGB());
                }
            }
            int newTextureId = TextureUtil.func_110989_a((int)TextureUtil.func_110996_a(), (BufferedImage)newImage, (boolean)false, (boolean)false);
            textureCache.put(key, newTextureId);
            System.out.println("Criada nova textura remapeada com ID: " + newTextureId);
            return newTextureId;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private static Color lerpColor(Color start, Color end, float factor, int alpha) {
        float r = ((float)start.getRed() + factor * (float)(end.getRed() - start.getRed())) / 255.0f;
        float g = ((float)start.getGreen() + factor * (float)(end.getGreen() - start.getGreen())) / 255.0f;
        float b = ((float)start.getBlue() + factor * (float)(end.getBlue() - start.getBlue())) / 255.0f;
        return new Color(RecolorizedTextureManager.clamp(r), RecolorizedTextureManager.clamp(g), RecolorizedTextureManager.clamp(b), (float)alpha / 255.0f);
    }

    private static Color scaleColor(Color base, float brightness, int alpha) {
        float r = (float)base.getRed() * brightness / 255.0f;
        float g = (float)base.getGreen() * brightness / 255.0f;
        float b = (float)base.getBlue() * brightness / 255.0f;
        return new Color(RecolorizedTextureManager.clamp(r), RecolorizedTextureManager.clamp(g), RecolorizedTextureManager.clamp(b), (float)alpha / 255.0f);
    }

    private static float clamp(float val) {
        return Math.max(0.0f, Math.min(1.0f, val));
    }

    public static void cleanup() {
        for (Integer textureId : textureCache.values()) {
            TextureUtil.func_147942_a((int)textureId);
        }
        textureCache.clear();
    }

    private static class CacheKey {
        private final ResourceLocation location;
        private final int c1;
        private final int c2;
        private final int c3;

        public CacheKey(ResourceLocation location, Color c1, Color c2, Color c3) {
            this.location = location;
            this.c1 = c1.getRGB();
            this.c2 = c2.getRGB();
            this.c3 = c3.getRGB();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.c1 == cacheKey.c1 && this.c2 == cacheKey.c2 && this.c3 == cacheKey.c3 && this.location.equals((Object)cacheKey.location);
        }

        public int hashCode() {
            return Objects.hash(this.location, this.c1, this.c2, this.c3);
        }
    }
}

