/*
 * Decompiled with CFR 0.152.
 */
package JinRyuu.DragonBC.common.mixin.pl;

import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinPlugin
implements IMixinConfigPlugin {
    private static final Path MODS_DIRECTORY_PATH = new File(Launch.minecraftHome, "mods/").toPath();

    @Override
    public void onLoad(String mixinPackage) {
    }

    @Override
    public String getRefMapperConfig() {
        return null;
    }

    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    @Override
    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    @Override
    public List<String> getMixins() {
        boolean isDevelopmentEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        List<TargetedMod> loadedMods = Arrays.stream(TargetedMod.values()).filter(mod -> mod == TargetedMod.VANILLA || mod.loadInDevelopment && isDevelopmentEnvironment || this.loadJarOf((TargetedMod)((Object)mod))).collect(Collectors.toList());
        for (TargetedMod mod2 : TargetedMod.values()) {
            if (!loadedMods.contains((Object)mod2)) continue;
        }
        ArrayList<String> mixins = new ArrayList<String>();
        mixins.add("MixinMinecraft");
        mixins.add("MixinEntityPlayerSP");
        mixins.add("MixinFMLClientHandler");
        mixins.add("MixinEntityRenderer");
        mixins.add("MixinRenderPlayer");
        for (Mixin mixin : Mixin.values()) {
            if (!mixin.shouldLoad(loadedMods)) continue;
            mixins.add(mixin.mixinClass);
        }
        return mixins;
    }

    private boolean loadJarOf(TargetedMod mod) {
        try {
            File jar = MixinPlugin.findJarOf(mod);
            if (jar == null) {
                return false;
            }
            if (!jar.exists()) {
                throw new FileNotFoundException(jar.toString());
            }
            LaunchClassLoader loader = Launch.classLoader;
            loader.addURL(jar.toURI().toURL());
            loader.getSources().remove(loader.getSources().size() - 1);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static File findJarOf(TargetedMod mod) {
        try {
            Objects.requireNonNull(mod);
            return Files.walk(MODS_DIRECTORY_PATH, new FileVisitOption[0]).filter(mod::isMatchingJar).map(Path::toFile).findFirst().orElse(null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    @Override
    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public static enum TargetedMod {
        VANILLA("Minecraft", true, "unused"),
        GECKOLIB3("geckolib3", true, "geckolib3");

        public final String modName;
        public final String[] jarNamePrefixes;
        public final boolean loadInDevelopment;

        private TargetedMod(String modName, boolean loadInDevelopment, String ... jarNamePrefixes) {
            this.modName = modName;
            this.jarNamePrefixes = jarNamePrefixes;
            this.loadInDevelopment = loadInDevelopment;
        }

        public boolean isMatchingJar(Path path) {
            String pathString = path.toString();
            String nameLowerCase = com.google.common.io.Files.getNameWithoutExtension((String)pathString).toLowerCase();
            String fileExtension = com.google.common.io.Files.getFileExtension((String)pathString);
            for (String jarNamePrefix : this.jarNamePrefixes) {
                if (!nameLowerCase.startsWith(jarNamePrefix.toLowerCase()) || !"jar".equals(fileExtension) && !"litemod".equals(fileExtension)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "TargetedMod{modName='" + this.modName + '\'' + ", jarNamePrefixes='" + Arrays.toString(this.jarNamePrefixes) + '\'' + '}';
        }
    }

    static enum Side {
        BOTH,
        CLIENT,
        SERVER;

    }

    public static enum Mixin {
        MixinDataInventory("gay.MixinClientPlayer", Side.CLIENT, TargetedMod.GECKOLIB3);

        private final Side side;
        public final List<TargetedMod> targetedMods;
        public final String mixinClass;

        private Mixin(String mixinClass, Side side, TargetedMod ... targetedMods) {
            this.mixinClass = mixinClass;
            this.targetedMods = Arrays.asList(targetedMods);
            this.side = side;
        }

        private Mixin(String mixinClass, TargetedMod ... targetedMods) {
            this.mixinClass = mixinClass;
            this.targetedMods = Arrays.asList(targetedMods);
            this.side = Side.BOTH;
        }

        public boolean shouldLoad(List<TargetedMod> loadedMods) {
            return (this.side == Side.BOTH || this.side == Side.SERVER && FMLLaunchHandler.side().isServer() || this.side == Side.CLIENT && FMLLaunchHandler.side().isClient()) && new HashSet<TargetedMod>(loadedMods).containsAll(this.targetedMods);
        }
    }
}

