/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogCategory;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestCategory;

public class SyncController {
    public static void syncPlayer(EntityPlayerMP player) {
        NBTTagList list = new NBTTagList();
        NBTTagCompound compound = new NBTTagCompound();
        for (Faction faction : FactionController.getInstance().factions.values()) {
            NBTTagCompound factioNBT = new NBTTagCompound();
            faction.writeNBT(factioNBT);
            list.func_74742_a((NBTBase)factioNBT);
            if (list.func_74745_c() <= 10) continue;
            compound = new NBTTagCompound();
            compound.func_74782_a("Data", (NBTBase)list);
            Server.sendData(player, EnumPacketClient.SYNC_ADD, 1, compound);
            list = new NBTTagList();
        }
        compound = new NBTTagCompound();
        compound.func_74782_a("Data", (NBTBase)list);
        Server.sendData(player, EnumPacketClient.SYNC_END, 1, compound);
        for (QuestCategory questCategory : QuestController.Instance.categories.values()) {
            NBTTagCompound questCompound;
            NBTTagList questList = new NBTTagList();
            for (int questID : questCategory.quests.keySet()) {
                Quest quest = questCategory.quests.get(questID);
                questList.func_74742_a((NBTBase)quest.writeToNBT(new NBTTagCompound()));
                if (questList.func_74745_c() <= 40) continue;
                questCompound = new NBTTagCompound();
                questCompound.func_74782_a("Data", (NBTBase)questList);
                questCompound.func_74782_a("CatNBT", (NBTBase)questCategory.writeSmallNBT(new NBTTagCompound()));
                Server.sendData(player, EnumPacketClient.SYNC_ADD, 3, questCompound);
                questList = new NBTTagList();
            }
            questCompound = new NBTTagCompound();
            questCompound.func_74782_a("Data", (NBTBase)questList);
            questCompound.func_74782_a("CatNBT", (NBTBase)questCategory.writeSmallNBT(new NBTTagCompound()));
            Server.sendData(player, EnumPacketClient.SYNC_ADD, 3, questCompound);
        }
        Server.sendData(player, EnumPacketClient.SYNC_END, 3, new NBTTagCompound());
        for (DialogCategory dialogCategory : DialogController.Instance.categories.values()) {
            NBTTagCompound dialogCompound;
            NBTTagList dialogList = new NBTTagList();
            for (int dialogID : dialogCategory.dialogs.keySet()) {
                Dialog dialog = dialogCategory.dialogs.get(dialogID);
                dialogList.func_74742_a((NBTBase)dialog.writeToNBT(new NBTTagCompound()));
                if (dialogList.func_74745_c() <= 40) continue;
                dialogCompound = new NBTTagCompound();
                dialogCompound.func_74782_a("Data", (NBTBase)dialogList);
                dialogCompound.func_74782_a("CatNBT", (NBTBase)dialogCategory.writeSmallNBT(new NBTTagCompound()));
                Server.sendData(player, EnumPacketClient.SYNC_ADD, 5, dialogCompound);
                dialogList = new NBTTagList();
            }
            dialogCompound = new NBTTagCompound();
            dialogCompound.func_74782_a("Data", (NBTBase)dialogList);
            dialogCompound.func_74782_a("CatNBT", (NBTBase)dialogCategory.writeSmallNBT(new NBTTagCompound()));
            Server.sendData(player, EnumPacketClient.SYNC_ADD, 5, dialogCompound);
        }
        Server.sendData(player, EnumPacketClient.SYNC_END, 5, new NBTTagCompound());
        PlayerData data = PlayerData.get((EntityPlayer)player);
        if (data != null) {
            NoppesUtilServer.sendPlayerDataCompound(player, data.getSyncNBTFull(), false);
        }
    }

    public static void syncAllDialogs() {
        for (DialogCategory category : DialogController.Instance.categories.values()) {
            NBTTagCompound dialogCompound;
            NBTTagList dialogList = new NBTTagList();
            for (int dialogID : category.dialogs.keySet()) {
                Dialog dialog = category.dialogs.get(dialogID);
                dialogList.func_74742_a((NBTBase)dialog.writeToNBT(new NBTTagCompound()));
                if (dialogList.func_74745_c() <= 40) continue;
                dialogCompound = new NBTTagCompound();
                dialogCompound.func_74782_a("Data", (NBTBase)dialogList);
                dialogCompound.func_74782_a("CatNBT", (NBTBase)category.writeSmallNBT(new NBTTagCompound()));
                Server.sendToAll(EnumPacketClient.SYNC_ADD, 5, dialogCompound);
                dialogList = new NBTTagList();
            }
            dialogCompound = new NBTTagCompound();
            dialogCompound.func_74782_a("Data", (NBTBase)dialogList);
            dialogCompound.func_74782_a("CatNBT", (NBTBase)category.writeSmallNBT(new NBTTagCompound()));
            Server.sendToAll(EnumPacketClient.SYNC_ADD, 5, dialogCompound);
        }
        Server.sendToAll(EnumPacketClient.SYNC_END, 5, new NBTTagCompound());
    }

    public static void syncAllQuests() {
        for (QuestCategory category : QuestController.Instance.categories.values()) {
            NBTTagCompound questCompound;
            NBTTagList questList = new NBTTagList();
            for (int questID : category.quests.keySet()) {
                Quest quest = category.quests.get(questID);
                questList.func_74742_a((NBTBase)quest.writeToNBT(new NBTTagCompound()));
                if (questList.func_74745_c() <= 40) continue;
                questCompound = new NBTTagCompound();
                questCompound.func_74782_a("Data", (NBTBase)questList);
                questCompound.func_74782_a("CatNBT", (NBTBase)category.writeSmallNBT(new NBTTagCompound()));
                Server.sendToAll(EnumPacketClient.SYNC_ADD, 3, questCompound);
                questList = new NBTTagList();
            }
            questCompound = new NBTTagCompound();
            questCompound.func_74782_a("Data", (NBTBase)questList);
            questCompound.func_74782_a("CatNBT", (NBTBase)category.writeSmallNBT(new NBTTagCompound()));
            Server.sendToAll(EnumPacketClient.SYNC_ADD, 3, questCompound);
        }
        Server.sendToAll(EnumPacketClient.SYNC_END, 3, new NBTTagCompound());
    }

    public static void updateQuestCat(QuestCategory questCategory) {
        NBTTagCompound questCompound;
        NBTTagList questList = new NBTTagList();
        for (int questID : questCategory.quests.keySet()) {
            Quest quest = questCategory.quests.get(questID);
            questList.func_74742_a((NBTBase)quest.writeToNBT(new NBTTagCompound()));
            if (questList.func_74745_c() <= 40) continue;
            questCompound = new NBTTagCompound();
            questCompound.func_74782_a("Data", (NBTBase)questList);
            questCompound.func_74782_a("CatNBT", (NBTBase)questCategory.writeSmallNBT(new NBTTagCompound()));
            Server.sendToAll(EnumPacketClient.SYNC_UPDATE, 3, questCompound);
            questList = new NBTTagList();
        }
        questCompound = new NBTTagCompound();
        questCompound.func_74782_a("Data", (NBTBase)questList);
        questCompound.func_74782_a("CatNBT", (NBTBase)questCategory.writeSmallNBT(new NBTTagCompound()));
        Server.sendToAll(EnumPacketClient.SYNC_UPDATE, 3, questCompound);
    }

    public static void updateDialogCat(DialogCategory dialogCategory) {
        NBTTagCompound dialogCompound;
        NBTTagList dialogList = new NBTTagList();
        for (int questID : dialogCategory.dialogs.keySet()) {
            Dialog dialog = dialogCategory.dialogs.get(questID);
            dialogList.func_74742_a((NBTBase)dialog.writeToNBT(new NBTTagCompound()));
            if (dialogList.func_74745_c() <= 40) continue;
            dialogCompound = new NBTTagCompound();
            dialogCompound.func_74782_a("Data", (NBTBase)dialogList);
            dialogCompound.func_74782_a("CatNBT", (NBTBase)dialogCategory.writeSmallNBT(new NBTTagCompound()));
            Server.sendToAll(EnumPacketClient.SYNC_UPDATE, 5, dialogCompound);
            dialogList = new NBTTagList();
        }
        dialogCompound = new NBTTagCompound();
        dialogCompound.func_74782_a("Data", (NBTBase)dialogList);
        dialogCompound.func_74782_a("CatNBT", (NBTBase)dialogCategory.writeSmallNBT(new NBTTagCompound()));
        Server.sendToAll(EnumPacketClient.SYNC_UPDATE, 5, dialogCompound);
    }

    public static void clientSync(int synctype, NBTTagCompound compound, boolean syncEnd) {
        if (synctype == 1) {
            NBTTagList list = compound.func_150295_c("Data", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                Faction faction = new Faction();
                faction.readNBT(list.func_150305_b(i));
                FactionController.getInstance().factionsSync.put(faction.id, faction);
            }
            if (syncEnd) {
                FactionController.getInstance().factions = FactionController.getInstance().factionsSync;
                FactionController.getInstance().factionsSync = new HashMap();
            }
        } else if (synctype == 3) {
            if (!compound.func_82582_d()) {
                QuestCategory category = new QuestCategory();
                category.readSmallNBT(compound.func_74775_l("CatNBT"));
                NBTTagList list = compound.func_150295_c("Data", 10);
                if (QuestController.Instance.categoriesSync.containsKey(category.id)) {
                    category = QuestController.Instance.categoriesSync.get(category.id);
                    category.readSmallNBT(compound.func_74775_l("CatNBT"));
                }
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    Quest quest = new Quest();
                    quest.readNBT(list.func_150305_b(i));
                    quest.category = category;
                    category.quests.put(quest.id, quest);
                }
                QuestController.Instance.categoriesSync.put(category.id, category);
            }
            if (syncEnd) {
                HashMap<Integer, Quest> quests = new HashMap<Integer, Quest>();
                for (QuestCategory category : QuestController.Instance.categoriesSync.values()) {
                    for (Quest quest : category.quests.values()) {
                        quests.put(quest.id, quest);
                    }
                }
                QuestController.Instance.categories = QuestController.Instance.categoriesSync;
                QuestController.Instance.quests = quests;
                QuestController.Instance.categoriesSync = new HashMap();
            }
        } else if (synctype == 5) {
            if (!compound.func_82582_d()) {
                DialogCategory category = new DialogCategory();
                category.readSmallNBT(compound.func_74775_l("CatNBT"));
                NBTTagList list = compound.func_150295_c("Data", 10);
                if (DialogController.Instance.categoriesSync.containsKey(category.id)) {
                    category = DialogController.Instance.categoriesSync.get(category.id);
                    category.readSmallNBT(compound.func_74775_l("CatNBT"));
                }
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    Dialog dialog = new Dialog();
                    dialog.readNBT(list.func_150305_b(i));
                    dialog.category = category;
                    category.dialogs.put(dialog.id, dialog);
                }
                DialogController.Instance.categoriesSync.put(category.id, category);
            }
            if (syncEnd) {
                HashMap<Integer, Dialog> dialogs = new HashMap<Integer, Dialog>();
                for (DialogCategory category : DialogController.Instance.categoriesSync.values()) {
                    for (Dialog dialog : category.dialogs.values()) {
                        dialogs.put(dialog.id, dialog);
                    }
                }
                DialogController.Instance.categories = DialogController.Instance.categoriesSync;
                DialogController.Instance.dialogs = dialogs;
                DialogController.Instance.categoriesSync = new HashMap();
            }
        }
    }

    public static void clientSyncUpdate(int synctype, NBTTagCompound compound, ByteBuf buffer) {
        if (synctype == 1) {
            Faction faction = new Faction();
            faction.readNBT(compound);
            FactionController.getInstance().factions.put(faction.id, faction);
        } else if (synctype == 4) {
            DialogCategory category = DialogController.Instance.categories.get(buffer.readInt());
            Dialog dialog = new Dialog();
            dialog.category = category;
            dialog.readNBT(compound);
            DialogController.Instance.dialogs.put(dialog.id, dialog);
            category.dialogs.put(dialog.id, dialog);
        } else if (synctype == 5) {
            DialogCategory category = new DialogCategory();
            category.readSmallNBT(compound.func_74775_l("CatNBT"));
            NBTTagList list = compound.func_150295_c("Data", 10);
            if (DialogController.Instance.categoriesSync.containsKey(category.id)) {
                category = DialogController.Instance.categoriesSync.get(category.id);
                category.readSmallNBT(compound.func_74775_l("CatNBT"));
            }
            for (int i = 0; i < list.func_74745_c(); ++i) {
                Dialog dialog = new Dialog();
                dialog.readNBT(list.func_150305_b(i));
                dialog.category = category;
                category.dialogs.put(dialog.id, dialog);
            }
            DialogController.Instance.categoriesSync.put(category.id, category);
        } else if (synctype == 2) {
            QuestCategory category = QuestController.Instance.categories.get(buffer.readInt());
            Quest quest = new Quest();
            quest.category = category;
            quest.readNBT(compound);
            QuestController.Instance.quests.put(quest.id, quest);
            category.quests.put(quest.id, quest);
        } else if (synctype == 3) {
            QuestCategory category = new QuestCategory();
            category.readSmallNBT(compound.func_74775_l("CatNBT"));
            NBTTagList list = compound.func_150295_c("Data", 10);
            if (QuestController.Instance.categoriesSync.containsKey(category.id)) {
                category = QuestController.Instance.categoriesSync.get(category.id);
                category.readSmallNBT(compound.func_74775_l("CatNBT"));
            }
            for (int i = 0; i < list.func_74745_c(); ++i) {
                Quest quest = new Quest();
                quest.readNBT(list.func_150305_b(i));
                quest.category = category;
                category.quests.put(quest.id, quest);
            }
            QuestController.Instance.categories.put(category.id, category);
        }
    }

    public static void clientSyncRemove(int synctype, int id) {
        QuestCategory category;
        if (synctype == 1) {
            FactionController.getInstance().factions.remove(id);
        } else if (synctype == 4) {
            Dialog dialog = DialogController.Instance.dialogs.remove(id);
            if (dialog != null) {
                dialog.category.dialogs.remove(id);
            }
        } else if (synctype == 5) {
            DialogCategory category2 = DialogController.Instance.categories.remove(id);
            if (category2 != null) {
                DialogController.Instance.dialogs.keySet().removeAll(category2.dialogs.keySet());
            }
        } else if (synctype == 2) {
            Quest quest = QuestController.Instance.quests.remove(id);
            if (quest != null) {
                quest.category.quests.remove(id);
            }
        } else if (synctype == 3 && (category = QuestController.Instance.categories.remove(id)) != null) {
            QuestController.Instance.quests.keySet().removeAll(category.quests.keySet());
        }
    }
}

