/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.command;

import foxz.utils.Market;
import java.util.Arrays;
import java.util.Set;
import kamkeel.command.CommandKamkeelBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockVine;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.Server;
import noppes.npcs.config.ConfigMain;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.ChunkController;
import noppes.npcs.controllers.PlayerDataController;

public class ConfigCommand
extends CommandKamkeelBase {
    public String func_71517_b() {
        return "config";
    }

    @Override
    public String getDescription() {
        return "Some config things you can set";
    }

    @CommandKamkeelBase.SubCommand(desc="Disable/Enable the natural leaves decay", usage="[true/false]", permission=4)
    public void leavesdecay(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            ConfigCommand.sendResult(sender, "LeavesDecay: \u00a7c" + ConfigMain.LeavesDecayEnabled, new Object[0]);
        } else {
            ConfigMain.LeavesDecayEnabled = Boolean.parseBoolean(args[0]);
            ConfigMain.LeavesDecayEnabledProperty.set(ConfigMain.LeavesDecayEnabled);
            if (ConfigMain.config.hasChanged()) {
                ConfigMain.config.save();
            }
            Set names = Block.field_149771_c.func_148742_b();
            for (ResourceLocation name : names) {
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)name);
                if (!(block instanceof BlockLeavesBase)) continue;
                block.func_149675_a(ConfigMain.LeavesDecayEnabled);
            }
            ConfigCommand.sendResult(sender, "LeavesDecay is now \u00a7c" + ConfigMain.LeavesDecayEnabled, new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Disable/Enable the vines growing", usage="[true/false]", permission=4)
    public void vinegrowth(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            ConfigCommand.sendResult(sender, "VineGrowth: \u00a7c" + ConfigMain.VineGrowthEnabled, new Object[0]);
        } else {
            ConfigMain.VineGrowthEnabled = Boolean.parseBoolean(args[0]);
            ConfigMain.VineGrowthEnabledProperty.set(ConfigMain.VineGrowthEnabled);
            if (ConfigMain.config.hasChanged()) {
                ConfigMain.config.save();
            }
            Set names = Block.field_149771_c.func_148742_b();
            for (ResourceLocation name : names) {
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)name);
                if (!(block instanceof BlockVine)) continue;
                block.func_149675_a(ConfigMain.VineGrowthEnabled);
            }
            ConfigCommand.sendResult(sender, "VineGrowth is now \u00a7c" + ConfigMain.VineGrowthEnabled, new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Disable/Enable the ice melting", usage="[true/false]", permission=4)
    public void icemelts(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            ConfigCommand.sendResult(sender, "IceMelts: \u00a7c" + ConfigMain.IceMeltsEnabled, new Object[0]);
        } else {
            ConfigMain.IceMeltsEnabled = Boolean.parseBoolean(args[0]);
            ConfigMain.IceMeltsEnabledProperty.set(ConfigMain.IceMeltsEnabled);
            if (ConfigMain.config.hasChanged()) {
                ConfigMain.config.save();
            }
            Set names = Block.field_149771_c.func_148742_b();
            for (ResourceLocation name : names) {
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)name);
                if (!(block instanceof BlockIce)) continue;
                block.func_149675_a(ConfigMain.IceMeltsEnabled);
            }
            ConfigCommand.sendResult(sender, "IceMelts is now \u00a7c" + ConfigMain.IceMeltsEnabled, new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Disable/Enable guns shooting", usage="[true/false]", permission=4)
    public void guns(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            ConfigCommand.sendResult(sender, "GunsEnabled: \u00a7c" + ConfigMain.GunsEnabled, new Object[0]);
        } else {
            ConfigMain.GunsEnabled = Boolean.parseBoolean(args[0]);
            ConfigMain.GunsEnabledProperty.set(ConfigMain.GunsEnabled);
            if (ConfigMain.config.hasChanged()) {
                ConfigMain.config.save();
            }
            ConfigCommand.sendResult(sender, "GunsEnabled is now \u00a7c" + ConfigMain.GunsEnabled, new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Freezes/Unfreezes npcs", usage="[true/false]", permission=4)
    public void freezenpcs(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            ConfigCommand.sendResult(sender, "Frozen NPCs: \u00a7c" + CustomNpcs.FreezeNPCs, new Object[0]);
        } else {
            CustomNpcs.FreezeNPCs = Boolean.parseBoolean(args[0]);
            ConfigCommand.sendResult(sender, "FrozenNPCs is now \u00a7c" + CustomNpcs.FreezeNPCs, new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Set number of active chunkloaders", usage="<number>", permission=4)
    public void chunkloaders(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            ConfigCommand.sendResult(sender, "ChunkLoaders: \u00a7c" + ChunkController.Instance.size() + "\u00a77/\u00a7c" + ConfigMain.ChunkLoaders, new Object[0]);
        } else {
            int size;
            try {
                ConfigMain.ChunkLoaders = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException ex) {
                ConfigCommand.sendError(sender, "Did not get a number: " + args[0], new Object[0]);
                return;
            }
            ConfigMain.ChunkLoadersProperty.set(ConfigMain.ChunkLoaders);
            if (ConfigMain.config.hasChanged()) {
                ConfigMain.config.save();
            }
            if ((size = ChunkController.Instance.size()) > ConfigMain.ChunkLoaders) {
                ChunkController.Instance.unload(size - ConfigMain.ChunkLoaders);
                ConfigCommand.sendResult(sender, size - ConfigMain.ChunkLoaders + " chunksloaders unloaded", new Object[0]);
            }
            ConfigCommand.sendResult(sender, "ChunkLoaders: \u00a7c" + ChunkController.Instance.size() + "\u00a77/\u00a7c" + ConfigMain.ChunkLoaders, new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Generate PlayerData to JSON/DAT", usage="[fileType] [convert]", permission=4)
    public void playerdata(ICommandSender sender, String[] args) throws CommandException {
        String fileType = ConfigMain.DatFormat ? "DAT" : "JSON";
        if (args.length == 0) {
            ConfigCommand.sendResult(sender, "PlayerData Filetype: \u00a7c" + fileType, new Object[0]);
        } else if (args.length == 1) {
            ConfigCommand.sendResult(sender, "Please write the word 'convert' at the end to confirm.  \u00a7c<dat/json> convert", new Object[0]);
        } else {
            if (args.length != 2) {
                ConfigCommand.sendError(sender, "Two many arguments", new Object[0]);
                return;
            }
            String formatType = args[0].toLowerCase();
            if (!formatType.equals("dat") && !formatType.equals("json")) {
                ConfigCommand.sendError(sender, "Invalid Format Type - Please use dat or json", new Object[0]);
                return;
            }
            String convert = args[1].toLowerCase();
            if (!convert.equals("convert")) {
                ConfigCommand.sendError(sender, "Please enter the word 'convert' at the end", new Object[0]);
                return;
            }
            boolean convertToDat = formatType.equals("dat");
            EntityPlayerMP send = null;
            if (sender instanceof EntityPlayerMP) {
                send = (EntityPlayerMP)sender;
            }
            ConfigCommand.sendResult(sender, "Started Conversion Process for PlayerData", new Object[0]);
            PlayerDataController.Instance.convertPlayerFiles(send, convertToDat);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Generate Market to JSON/DAT", usage="[fileType] [convert]", permission=4)
    public void market(ICommandSender sender, String[] args) throws CommandException {
        String fileType = ConfigMain.MarketDatFormat ? "DAT" : "JSON";
        if (args.length == 0) {
            ConfigCommand.sendResult(sender, "Market Filetype: \u00a7c" + fileType, new Object[0]);
        } else if (args.length == 1) {
            ConfigCommand.sendResult(sender, "Please write the word 'convert' at the end to confirm.  \u00a7c<dat/json> convert", new Object[0]);
        } else {
            if (args.length != 2) {
                ConfigCommand.sendError(sender, "Two many arguments", new Object[0]);
                return;
            }
            String formatType = args[0].toLowerCase();
            if (!formatType.equals("dat") && !formatType.equals("json")) {
                ConfigCommand.sendError(sender, "Invalid Format Type - Please use dat or json", new Object[0]);
                return;
            }
            String convert = args[1].toLowerCase();
            if (!convert.equals("convert")) {
                ConfigCommand.sendError(sender, "Please enter the word 'convert' at the end", new Object[0]);
                return;
            }
            boolean convertToDat = formatType.equals("dat");
            EntityPlayerMP send = null;
            if (sender instanceof EntityPlayerMP) {
                send = (EntityPlayerMP)sender;
            }
            ConfigCommand.sendResult(sender, "Started Conversion Process for Market", new Object[0]);
            Market.convertMarketFiles(send, convertToDat);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Get/Set font", usage="[type] [size]", permission=4)
    public void font(ICommandSender sender, String[] args) {
        if (!(sender instanceof EntityPlayerMP)) {
            return;
        }
        int size = 18;
        if (args.length > 1) {
            try {
                size = Integer.parseInt(args[args.length - 1]);
                args = Arrays.copyOfRange(args, 0, args.length - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String font = "";
        for (int i = 0; i < args.length; ++i) {
            font = font + " " + args[i];
        }
        Server.sendData((EntityPlayerMP)sender, EnumPacketClient.CONFIG, 0, font.trim(), size);
    }
}

