/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.build.reverse;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import net.famzangl.minecraft.minebot.MinebotMod;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.command.AIChatController;
import net.famzangl.minecraft.minebot.build.blockbuild.BuildTask;
import net.famzangl.minecraft.minebot.build.blockbuild.TaskDescription;
import net.famzangl.minecraft.minebot.build.blockbuild.UnknownBlockException;
import net.famzangl.minecraft.minebot.build.reverse.ReverseBuildField;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;

public class BuildReverser {
    private final AIHelper helper;
    private final Pos pos1;
    private final Pos pos2;
    private final ReverseBuildField field;
    private String outFile;
    private PrintStream out;
    private int missingBlocks;

    public BuildReverser(AIHelper helper, String outFile) {
        this(helper, Pos.minPos(helper.getPos1(), helper.getPos2()), Pos.maxPos(helper.getPos1(), helper.getPos2()), outFile);
    }

    public BuildReverser(AIHelper helper, Pos pos1, Pos pos2, String outFile) {
        this.helper = helper;
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.field = new ReverseBuildField(pos2.x - pos1.x + 1, pos2.y - pos1.y + 1, pos2.z - pos1.z + 1);
        this.outFile = outFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.outFile == null || this.outFile.isEmpty() || "-".equals(this.outFile)) {
                this.outFile = "-";
                this.out = System.out;
            } else {
                this.out = new PrintStream(this.outFile);
            }
            this.out.println("# Minebot reverse build script " + MinebotMod.getVersion());
            this.out.println("# Pos1: " + this.pos1);
            this.out.println("# Pos2: " + this.pos2);
            this.out.println("");
            this.out.println("/minebuild reset");
            this.out.println("");
            for (int y = this.pos1.y; y <= this.pos2.y; ++y) {
                this.out.println("# Layer " + (y - this.pos1.y));
                for (int x = this.pos1.x; x <= this.pos2.x; ++x) {
                    boolean row2 = (x - this.pos1.x & 1) == 1;
                    this.addRow(new Pos(x, y, row2 ? this.pos2.z : this.pos1.z), row2 ? ForgeDirection.NORTH : ForgeDirection.SOUTH, this.pos2.z - this.pos1.z + 1);
                }
                this.out.println("");
            }
            this.out.println("#/minebuild build");
            if (this.missingBlocks > 0) {
                AIChatController.addChatLine("Could not convert " + this.missingBlocks + "blocks. They will be missing.");
            }
            AIChatController.addChatLine("Output written to: " + this.outFile);
        }
        catch (FileNotFoundException e) {
            AIChatController.addChatLine("File/dir does not exist: " + this.outFile);
        }
        catch (IOException e) {
            AIChatController.addChatLine("IO-Error for: " + this.outFile);
        }
        finally {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
    }

    public void addRow(Pos start, ForgeDirection direction, int length) {
        for (int i = 0; i < length; ++i) {
            this.addBuildPlace(start.x + direction.offsetX * i, start.y + direction.offsetY * i, start.z + direction.offsetZ * i);
        }
    }

    private void addBuildPlace(int x, int y, int z) {
        int lx = x - this.pos1.x;
        int ly = y - this.pos1.y;
        int lz = z - this.pos1.z;
        Block b = this.helper.getBlock(x, y, z);
        if (b != Blocks.field_150350_a) {
            try {
                TaskDescription taskString = BuildTask.getTaskDescription(b, this.helper, x, y, z);
                this.field.setBlockAt(lx, ly, lz, b, taskString);
                this.out.println("/minebuild schedule ~" + lx + " ~" + ly + " ~" + lz + " " + taskString.getCommandArgs());
            }
            catch (UnknownBlockException e) {
                this.out.println("# Missing: ~" + lx + " ~" + ly + " ~" + lz + " " + b.func_149732_F());
                ++this.missingBlocks;
            }
        }
    }
}

