/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.build.blockbuild;

import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.BlockItemFilter;
import net.famzangl.minecraft.minebot.ai.ItemFilter;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.move.UpwardsMoveTask;
import net.famzangl.minecraft.minebot.ai.task.place.SneakAndPlaceTask;
import net.famzangl.minecraft.minebot.build.blockbuild.BuildTask;

public abstract class CubeBuildTask
extends BuildTask {
    protected final BlockItemFilter blockFilter;
    protected static final Pos FROM_GROUND = new Pos(0, 0, 0);
    public static final Pos[] STANDABLE = new Pos[]{new Pos(-1, 1, 0), new Pos(0, 1, -1), new Pos(1, 1, 0), new Pos(0, 1, 1), FROM_GROUND};

    protected CubeBuildTask(Pos forPosition, BlockItemFilter blockFilter) {
        super(forPosition);
        this.blockFilter = blockFilter;
    }

    @Override
    public AITask getPlaceBlockTask(Pos relativeFromPos) {
        if (!this.isStandablePlace(relativeFromPos)) {
            return null;
        }
        if (relativeFromPos.equals(FROM_GROUND)) {
            return new UpwardsMoveTask(this.forPosition.x, this.forPosition.y + 1, this.forPosition.z, this.blockFilter);
        }
        return new SneakAndPlaceTask(this.forPosition.x, this.forPosition.y + 1, this.forPosition.z, this.blockFilter, relativeFromPos, this.getMinHeightToBuild());
    }

    protected double getMinHeightToBuild() {
        return (double)this.forPosition.y + this.getBlockHeight();
    }

    protected double getBlockHeight() {
        return 1.0;
    }

    @Override
    public Pos[] getStandablePlaces() {
        return STANDABLE;
    }

    @Override
    public boolean couldBuildFrom(AIHelper helper, int x, int y, int z) {
        if (!super.couldBuildFrom(helper, x, y, z)) {
            return false;
        }
        return !helper.isAirBlock(x, y - 1, z);
    }

    @Override
    public ItemFilter getRequiredItem() {
        return this.blockFilter;
    }
}

