/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.build.blockbuild;

import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.BlockItemFilter;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.BlockSide;
import net.famzangl.minecraft.minebot.ai.task.place.JumpingPlaceBlockAtSideTask;
import net.famzangl.minecraft.minebot.ai.task.place.SneakAndPlaceAtSideTask;
import net.famzangl.minecraft.minebot.build.blockbuild.BuildTask;
import net.famzangl.minecraft.minebot.build.blockbuild.CubeBuildTask;
import net.famzangl.minecraft.minebot.build.blockbuild.MirrorDirection;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;

public class BuildNormalStairsTask
extends CubeBuildTask {
    public static final Block[] BLOCKS = new Block[]{Blocks.field_150400_ck, Blocks.field_150487_bG, Blocks.field_150389_bf, Blocks.field_150401_cl, Blocks.field_150481_bH, Blocks.field_150387_bl, Blocks.field_150476_ad, Blocks.field_150372_bz, Blocks.field_150485_bF, Blocks.field_150390_bg, Blocks.field_150446_ar, Blocks.field_150370_cb};
    private final ForgeDirection upwardsDirection;
    private final boolean inverted;
    private final Block stairs;

    public BuildNormalStairsTask(Pos forPosition, Block stairs, ForgeDirection upwardsDirection, Half half) {
        super(forPosition, new BlockItemFilter(stairs));
        this.stairs = stairs;
        this.upwardsDirection = upwardsDirection;
        boolean bl = this.inverted = half == Half.UPPER;
        if (upwardsDirection != ForgeDirection.EAST && upwardsDirection != ForgeDirection.WEST && upwardsDirection != ForgeDirection.NORTH && upwardsDirection != ForgeDirection.SOUTH) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public AITask getPlaceBlockTask(Pos relativeFromPos) {
        BlockSide side;
        BlockSide blockSide = side = this.inverted ? BlockSide.UPPER_HALF : BlockSide.LOWER_HALF;
        if (!this.isStandablePlace(relativeFromPos)) {
            return null;
        }
        if (relativeFromPos.equals(FROM_GROUND)) {
            return new JumpingPlaceBlockAtSideTask(this.forPosition.x, this.forPosition.y + 1, this.forPosition.z, this.blockFilter, this.upwardsDirection.getOpposite(), side);
        }
        return new SneakAndPlaceAtSideTask(this.forPosition.x, this.forPosition.y + 1, this.forPosition.z, this.blockFilter, relativeFromPos, this.getMinHeightToBuild(), this.upwardsDirection.getOpposite(), side);
    }

    public String toString() {
        return "BuildNormalStairsTask [upwardsDirection=" + this.upwardsDirection + ", inverted=" + this.inverted + ", blockFilter=" + this.blockFilter + ", forPosition=" + this.forPosition + "]";
    }

    @Override
    public BuildTask withPositionAndRotation(Pos add, int rotateSteps, MirrorDirection mirror) {
        ForgeDirection dir = this.upwardsDirection;
        for (int i = 0; i < rotateSteps; ++i) {
            dir = dir.getRotation(ForgeDirection.UP);
        }
        if (mirror == MirrorDirection.EAST_WEST && dir == ForgeDirection.EAST) {
            dir = ForgeDirection.WEST;
        } else if (mirror == MirrorDirection.EAST_WEST && dir == ForgeDirection.WEST) {
            dir = ForgeDirection.EAST;
        } else if (mirror == MirrorDirection.NORTH_SOUTH && dir == ForgeDirection.NORTH) {
            dir = ForgeDirection.SOUTH;
        } else if (mirror == MirrorDirection.NORTH_SOUTH && dir == ForgeDirection.SOUTH) {
            dir = ForgeDirection.NORTH;
        }
        return new BuildNormalStairsTask(add, this.stairs, dir, this.inverted ? Half.UPPER : Half.LOWER);
    }

    public static enum Half {
        UPPER,
        LOWER;

    }
}

