/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.build;

import java.util.Arrays;
import java.util.LinkedList;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.BlockItemFilter;
import net.famzangl.minecraft.minebot.ai.BlockWhitelist;
import net.famzangl.minecraft.minebot.ai.path.MovePathFinder;
import net.famzangl.minecraft.minebot.ai.task.move.AlignToGridTask;
import net.famzangl.minecraft.minebot.build.WalkTowardsTask;
import net.famzangl.minecraft.minebot.build.blockbuild.BuildTask;
import net.minecraft.init.Blocks;

public class ForBuildPathFinder
extends MovePathFinder {
    private static final int NEIGHBOURS_PER_DIRECTION = 6;
    private static final BlockWhitelist FENCES = new BlockWhitelist(Blocks.field_150422_aJ, Blocks.field_150463_bK);
    private final BuildTask task;
    int[] res = new int[24];
    private boolean canBuildUp;
    private boolean noPathFound;

    public ForBuildPathFinder(BuildTask task) {
        this.task = task;
        this.allowedGroundForUpwardsBlocks = this.allowedGroundBlocks;
        this.footAllowedBlocks = AIHelper.walkableBlocks;
        this.headAllowedBlocks = AIHelper.headWalkableBlocks;
    }

    @Override
    protected boolean runSearch(Pos playerPosition) {
        this.canBuildUp = this.helper.canSelectItem(new BlockItemFilter(Blocks.field_150404_cg));
        return super.runSearch(playerPosition);
    }

    @Override
    protected int[] getNeighbours(int currentNode) {
        Arrays.fill(this.res, -1);
        int cx = this.getX(currentNode);
        int cz = this.getZ(currentNode);
        this.getNeighbours(this.res, 0, currentNode, cx + 1, cz);
        this.getNeighbours(this.res, 6, currentNode, cx - 1, cz);
        this.getNeighbours(this.res, 12, currentNode, cx, cz + 1);
        this.getNeighbours(this.res, 18, currentNode, cx, cz - 1);
        return this.res;
    }

    private void getNeighbours(int[] fill, int offset, int currentNode, int x, int z) {
        int y;
        int cy = this.getY(currentNode);
        int max = this.canBuildUp ? 3 : 1;
        for (y = cy + 1; y <= cy + max && this.helper.isAirBlock(this.getX(currentNode), y + 1, this.getZ(currentNode)); ++y) {
            fill[offset++] = this.getNeighbour(currentNode, x, y, z);
        }
        if (this.helper.isAirBlock(x, cy + 1, z)) {
            for (y = cy; y > cy - 3 && this.helper.isAirBlock(x, y, z); --y) {
                fill[offset++] = this.getNeighbour(currentNode, x, y, z);
            }
        }
    }

    @Override
    protected boolean checkGroundBlock(int currentNode, int cx, int cy, int cz) {
        return this.helper.isSafeGroundBlock(cx, cy - 1, cz) || this.helper.isAirBlock(cx, cy - 1, cz) && FENCES.contains(this.helper.getBlockId(cx, cy - 2, cz));
    }

    @Override
    protected int distanceFor(int from, int to) {
        if (this.getY(from) + 1 < this.getY(to)) {
            return 1 + Math.abs(this.getY(from) - this.getY(to)) * 4;
        }
        return 1 + Math.abs(this.getY(from) - this.getY(to));
    }

    @Override
    protected float rateDestination(int distance, int x, int y, int z) {
        if (this.task.couldBuildFrom(this.helper, x, y, z)) {
            return distance;
        }
        return -1.0f;
    }

    @Override
    protected void foundPath(LinkedList<Pos> path) {
        Pos currentPos = path.removeFirst();
        this.addTask(new AlignToGridTask(currentPos.x, currentPos.y, currentPos.z));
        while (!path.isEmpty()) {
            Pos nextPos = path.removeFirst();
            this.addTask(new WalkTowardsTask(currentPos, nextPos));
            currentPos = nextPos;
        }
        this.noPathFound = true;
    }

    @Override
    protected void noPathFound() {
        this.noPathFound = true;
        super.noPathFound();
    }

    public boolean isNoPathFound() {
        return this.noPathFound;
    }
}

