/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.task.place;

import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.BlockItemFilter;
import net.famzangl.minecraft.minebot.ai.strategy.TaskOperations;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.error.SelectTaskError;
import net.minecraft.util.MovementInput;
import net.minecraftforge.common.util.ForgeDirection;

public class SneakAndPlaceTask
extends AITask {
    protected final int x;
    protected final int y;
    protected final int z;
    protected final BlockItemFilter filter;
    protected final Pos relativeFrom;
    private final ForgeDirection inDirection;
    private final double minBuildHeight;
    private int faceTimer;

    public SneakAndPlaceTask(int x, int y, int z, BlockItemFilter filter, Pos relativeFrom, double minBuildHeight) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.filter = filter;
        this.relativeFrom = relativeFrom;
        this.minBuildHeight = minBuildHeight;
        ForgeDirection foundInDir = AIHelper.getDirectionForXZ(-relativeFrom.x, -relativeFrom.z);
        if (relativeFrom.y != 1 || foundInDir == null) {
            throw new IllegalArgumentException();
        }
        this.inDirection = foundInDir;
    }

    @Override
    public boolean isFinished(AIHelper h) {
        return !h.isAirBlock(this.x, this.y - 1, this.z) && !h.isJumping();
    }

    @Override
    public void runTick(AIHelper h, TaskOperations o) {
        if (this.faceTimer > 0) {
            --this.faceTimer;
        }
        if (h.sneakFrom(this.x + this.relativeFrom.x, this.y - 1, this.z + this.relativeFrom.z, this.inDirection)) {
            boolean hasRequiredHeight;
            boolean bl = hasRequiredHeight = h.getMinecraft().field_71439_g.field_70121_D.field_72338_b > this.minBuildHeight - 0.05;
            if (hasRequiredHeight) {
                if (this.faceTimer == 0) {
                    this.faceBlock(h, o);
                    this.faceTimer = 3;
                } else if (this.isFacingRightBlock(h)) {
                    if (h.selectCurrentItem(this.filter)) {
                        h.overrideUseItem();
                    } else {
                        o.desync(new SelectTaskError(this.filter));
                    }
                }
            } else {
                MovementInput i = new MovementInput();
                i.field_78901_c = true;
                h.overrideMovement(i);
            }
        }
    }

    protected boolean isFacingRightBlock(AIHelper h) {
        return h.isFacingBlock(this.x + this.relativeFrom.x, this.y - 1, this.z + this.relativeFrom.z, this.inDirection);
    }

    protected void faceBlock(AIHelper h, TaskOperations o) {
        h.faceSideOf(this.x + this.relativeFrom.x, this.y - 1, this.z + this.relativeFrom.z, this.inDirection);
    }

    public String toString() {
        return "SneakAndPlaceTask [x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", filter=" + this.filter + ", relativeFrom=" + this.relativeFrom + ", inDirection=" + this.inDirection + ", minBuildHeight=" + this.minBuildHeight + "]";
    }
}

