/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.task.place;

import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.BlockItemFilter;
import net.famzangl.minecraft.minebot.ai.strategy.TaskOperations;
import net.famzangl.minecraft.minebot.ai.task.BlockSide;
import net.famzangl.minecraft.minebot.ai.task.error.StringTaskError;
import net.famzangl.minecraft.minebot.ai.task.place.SneakAndPlaceTask;
import net.minecraftforge.common.util.ForgeDirection;

public class SneakAndPlaceAtHalfTask
extends SneakAndPlaceTask {
    protected final BlockSide side;
    protected ForgeDirection lookingDirection = ForgeDirection.UNKNOWN;
    protected final ForgeDirection[] DIRS = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.WEST, ForgeDirection.SOUTH};
    private int attempts;

    protected ForgeDirection[] getBuildDirs() {
        return this.DIRS;
    }

    public SneakAndPlaceAtHalfTask(int x, int y, int z, BlockItemFilter filter, Pos relativeFrom, double minBuildHeight, BlockSide side) {
        super(x, y, z, filter, relativeFrom, minBuildHeight);
        this.side = side;
    }

    @Override
    protected void faceBlock(AIHelper h, TaskOperations o) {
        ForgeDirection[] dirs = this.getBuildDirs();
        ++this.attempts;
        for (int i = 0; i < dirs.length; ++i) {
            ForgeDirection useSide = dirs[this.attempts / 10 % dirs.length];
            if (!h.isAirBlock(this.x + useSide.offsetX, this.y - 1, this.z + useSide.offsetZ)) {
                this.faceSideBlock(h, useSide);
                return;
            }
            this.attempts += 10;
        }
        o.desync(new StringTaskError("Could not face anywhere to place."));
    }

    private void faceSideBlock(AIHelper h, ForgeDirection useSide) {
        h.faceSideOf(this.x + useSide.offsetX, this.y - 1, this.z + useSide.offsetZ, useSide.getOpposite(), this.side == BlockSide.UPPER_HALF ? 0.5 : 0.0, this.side == BlockSide.LOWER_HALF ? 0.5 : 1.0, h.getMinecraft().field_71439_g.field_70165_t - (double)this.x, h.getMinecraft().field_71439_g.field_70161_v - (double)this.z, this.lookingDirection);
    }

    private boolean isFacing(AIHelper h, ForgeDirection dir) {
        return h.isFacingBlock(this.x + dir.offsetX, this.y - 1, this.z + dir.offsetZ, dir.getOpposite(), this.side);
    }

    @Override
    protected boolean isFacingRightBlock(AIHelper h) {
        for (ForgeDirection d : this.getBuildDirs()) {
            if (!this.isFacing(h, d)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "SneakAndPlaceAtHalfTask [side=" + (Object)((Object)this.side) + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", filter=" + this.filter + ", relativeFrom=" + this.relativeFrom + "]";
    }
}

