/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.task.place;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.ItemFilter;
import net.famzangl.minecraft.minebot.ai.task.BlockSide;
import net.famzangl.minecraft.minebot.ai.task.place.JumpingPlaceAtHalfTask;
import net.minecraftforge.common.util.ForgeDirection;

public class JumpingPlaceBlockAtSideTask
extends JumpingPlaceAtHalfTask {
    private final int attempts = 0;

    public JumpingPlaceBlockAtSideTask(int x, int y, int z, ItemFilter filter, ForgeDirection lookingDirection, BlockSide side) {
        super(x, y, z, filter, side);
        this.lookingDirection = lookingDirection;
    }

    @Override
    protected ForgeDirection[] getBuildDirs() {
        ForgeDirection[] forgeDirectionArray;
        if (this.side != BlockSide.UPPER_HALF) {
            ForgeDirection[] forgeDirectionArray2 = new ForgeDirection[4];
            forgeDirectionArray2[0] = ForgeDirection.DOWN;
            forgeDirectionArray2[1] = this.lookingDirection.getRotation(ForgeDirection.UP);
            forgeDirectionArray2[2] = this.lookingDirection.getRotation(ForgeDirection.DOWN);
            forgeDirectionArray = forgeDirectionArray2;
            forgeDirectionArray2[3] = this.lookingDirection;
        } else {
            ForgeDirection[] forgeDirectionArray3 = new ForgeDirection[3];
            forgeDirectionArray3[0] = this.lookingDirection.getRotation(ForgeDirection.UP);
            forgeDirectionArray3[1] = this.lookingDirection.getRotation(ForgeDirection.DOWN);
            forgeDirectionArray = forgeDirectionArray3;
            forgeDirectionArray3[2] = this.lookingDirection;
        }
        return forgeDirectionArray;
    }

    @Override
    protected boolean isFacingRightBlock(AIHelper h) {
        if (h.getLookDirection() != this.lookingDirection) {
            return false;
        }
        return this.isFacing(h, this.lookingDirection.getRotation(ForgeDirection.UP)) || this.isFacing(h, this.lookingDirection.getRotation(ForgeDirection.DOWN)) || this.isFacing(h, this.lookingDirection) || this.side != BlockSide.UPPER_HALF && h.isFacingBlock(this.x, this.getPlaceAtY() - 1, this.z, ForgeDirection.UP);
    }
}

