/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.task.place;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.ItemFilter;
import net.famzangl.minecraft.minebot.ai.strategy.TaskOperations;
import net.famzangl.minecraft.minebot.ai.task.BlockSide;
import net.famzangl.minecraft.minebot.ai.task.error.StringTaskError;
import net.famzangl.minecraft.minebot.ai.task.place.JumpingPlaceBlockAtFloorTask;
import net.minecraftforge.common.util.ForgeDirection;

public class JumpingPlaceAtHalfTask
extends JumpingPlaceBlockAtFloorTask {
    public static final ForgeDirection[] TRY_FOR_LOWER = new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.WEST, ForgeDirection.SOUTH};
    public static final ForgeDirection[] TRY_FOR_UPPER = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.WEST, ForgeDirection.SOUTH};
    protected BlockSide side;
    protected ForgeDirection lookingDirection = ForgeDirection.UNKNOWN;
    private int attempts;

    public JumpingPlaceAtHalfTask(int x, int y, int z, ItemFilter filter, BlockSide side) {
        super(x, y, z, filter);
        this.side = side;
    }

    @Override
    protected void faceBlock(AIHelper h, TaskOperations o) {
        ForgeDirection[] dirs = this.getBuildDirs();
        for (int i = 0; i < dirs.length; ++i) {
            if (!this.faceSideBlock(h, dirs[this.attempts++ % dirs.length])) continue;
            return;
        }
        o.desync(new StringTaskError("Could not face anywhere to place."));
    }

    protected ForgeDirection[] getBuildDirs() {
        return this.side == BlockSide.UPPER_HALF ? TRY_FOR_UPPER : TRY_FOR_LOWER;
    }

    protected boolean faceSideBlock(AIHelper h, ForgeDirection dir) {
        System.out.println("Facing side " + dir);
        int x2 = this.x + dir.offsetX;
        int y2 = this.getPlaceAtY() + dir.offsetY;
        int z2 = this.z + dir.offsetZ;
        if (h.isAirBlock(x2, y2, z2)) {
            return false;
        }
        h.faceSideOf(x2, y2, z2, dir.getOpposite(), this.getSide(dir) == BlockSide.UPPER_HALF ? 0.5 : 0.0, this.getSide(dir) == BlockSide.LOWER_HALF ? 0.5 : 1.0, h.getMinecraft().field_71439_g.field_70165_t - (double)this.x, h.getMinecraft().field_71439_g.field_70161_v - (double)this.z, this.lookingDirection);
        return true;
    }

    protected boolean isFacing(AIHelper h, ForgeDirection dir) {
        return h.isFacingBlock(this.x + dir.offsetX, this.getPlaceAtY() + dir.offsetY, this.z + dir.offsetZ, dir.getOpposite(), this.getSide(dir));
    }

    private BlockSide getSide(ForgeDirection dir) {
        return dir.offsetY < 0 ? BlockSide.UPPER_HALF : BlockSide.LOWER_HALF;
    }

    @Override
    protected boolean isFacingRightBlock(AIHelper h) {
        for (ForgeDirection d : this.getBuildDirs()) {
            if (!this.isFacing(h, d)) continue;
            return true;
        }
        return false;
    }
}

