/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.task.move;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.ItemFilter;
import net.famzangl.minecraft.minebot.ai.strategy.TaskOperations;
import net.famzangl.minecraft.minebot.ai.task.error.PositionTaskError;
import net.famzangl.minecraft.minebot.ai.task.place.JumpingPlaceBlockAtFloorTask;
import net.minecraft.init.Blocks;

public class UpwardsMoveTask
extends JumpingPlaceBlockAtFloorTask {
    private boolean obsidianMining;

    public UpwardsMoveTask(int x, int y, int z, ItemFilter filter) {
        super(x, y, z, filter);
    }

    @Override
    public void runTick(AIHelper h, TaskOperations o) {
        if (!h.isAirBlock(this.x, this.y + 1, this.z)) {
            if (!h.isStandingOn(this.x, this.y - 1, this.z)) {
                o.desync(new PositionTaskError(this.x, this.y - 1, this.z));
            }
            if (AIHelper.blockIsOneOf(h.getBlock(this.x, this.y + 1, this.z), Blocks.field_150343_Z)) {
                this.obsidianMining = true;
            }
            h.faceAndDestroy(this.x, this.y + 1, this.z);
        } else if (h.canWalkOn(h.getBlock(this.x, this.y - 1, this.z)) && !h.isAirBlock(this.x, this.y - 1, this.z)) {
            h.faceAndDestroy(this.x, this.y - 1, this.z);
        } else {
            super.runTick(h, o);
        }
    }

    @Override
    public int getGameTickTimeout() {
        return super.getGameTickTimeout() + (this.obsidianMining ? 200 : 0);
    }

    @Override
    public String toString() {
        return "UpwardsMoveTask [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }
}

