/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.task.move;

import java.util.List;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.strategy.TaskOperations;
import net.famzangl.minecraft.minebot.ai.task.move.HorizontalMoveTask;

public class JumpMoveTask
extends HorizontalMoveTask {
    private final int oldX;
    private final int oldZ;

    public JumpMoveTask(int x, int y, int z, int oldX, int oldZ) {
        super(x, y, z);
        this.oldX = oldX;
        this.oldZ = oldZ;
    }

    @Override
    protected boolean doJump(AIHelper h) {
        return true;
    }

    @Override
    public void runTick(AIHelper h, TaskOperations o) {
        if (!h.canWalkThrough(h.getBlock(this.oldX, this.y + 1, this.oldZ))) {
            h.faceAndDestroy(this.oldX, this.y + 1, this.oldZ);
        } else {
            super.runTick(h, o);
        }
    }

    @Override
    public String toString() {
        return "JumpMoveTask [oldX=" + this.oldX + ", oldZ=" + this.oldZ + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }

    @Override
    public List<Pos> getPredestroyPositions(AIHelper helper) {
        List<Pos> list = super.getPredestroyPositions(helper);
        list.add(0, new Pos(this.oldX, this.y + 1, this.oldZ));
        return list;
    }
}

