/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.task.move;

import java.util.ArrayList;
import java.util.List;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.strategy.TaskOperations;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.CanPrefaceAndDestroy;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class HorizontalMoveTask
extends AITask
implements CanPrefaceAndDestroy {
    static final int OBSIDIAN_TIME = 200;
    protected final int x;
    protected final int y;
    protected final int z;
    private boolean hasObsidianLower;
    private boolean hasObsidianUpper;

    public HorizontalMoveTask(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public boolean isFinished(AIHelper h) {
        return h.isStandingOn(this.x, this.y, this.z);
    }

    @Override
    public void runTick(AIHelper h, TaskOperations o) {
        Block upper = h.getBlock(this.x, this.y + 1, this.z);
        if (!h.canWalkThrough(upper)) {
            if (AIHelper.blockIsOneOf(upper, Blocks.field_150343_Z)) {
                this.hasObsidianUpper = true;
            }
            h.faceAndDestroyWithHangingBlock(this.x, this.y + 1, this.z);
        } else {
            Block lower = h.getBlock(this.x, this.y, this.z);
            if (!h.canWalkOn(lower)) {
                if (AIHelper.blockIsOneOf(lower, Blocks.field_150343_Z)) {
                    this.hasObsidianLower = true;
                }
                h.faceAndDestroyWithHangingBlock(this.x, this.y, this.z);
            } else {
                boolean nextIsFacing = o.faceAndDestroyForNextTask();
                h.walkTowards((double)this.x + 0.5, (double)this.z + 0.5, this.doJump(h), !nextIsFacing);
            }
        }
    }

    @Override
    public int getGameTickTimeout() {
        return super.getGameTickTimeout() + (this.hasObsidianLower ? 200 : 0) + (this.hasObsidianUpper ? 200 : 0);
    }

    protected boolean doJump(AIHelper h) {
        return false;
    }

    public String toString() {
        return "HorizontalMoveTask [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }

    @Override
    public List<Pos> getPredestroyPositions(AIHelper helper) {
        ArrayList<Pos> arrayList = new ArrayList<Pos>();
        if (!helper.canWalkThrough(helper.getBlock(this.x, this.y + 1, this.z))) {
            arrayList.add(new Pos(this.x, this.y + 1, this.z));
        }
        if (!helper.canWalkOn(helper.getBlock(this.x, this.y, this.z))) {
            arrayList.add(new Pos(this.x, this.y, this.z));
        }
        return arrayList;
    }
}

