/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.task;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.ItemFilter;
import net.famzangl.minecraft.minebot.ai.strategy.TaskOperations;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.minecraft.util.MovingObjectPosition;

public class UseItemTask
extends AITask {
    private boolean clicked;
    private final ItemFilter filter;

    public UseItemTask() {
        this(null);
    }

    public UseItemTask(ItemFilter filter) {
        this.filter = filter;
    }

    @Override
    public boolean isFinished(AIHelper h) {
        return this.clicked;
    }

    @Override
    public void runTick(AIHelper h, TaskOperations o) {
        if (!this.clicked) {
            if (this.filter != null && !h.selectCurrentItem(this.filter)) {
                return;
            }
            MovingObjectPosition objectMouseOver = h.getObjectMouseOver();
            if (objectMouseOver == null || objectMouseOver.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                this.notFacingBlock(h);
                return;
            }
            if (!this.isBlockAllowed(h, objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d)) {
                this.notFacingBlock(h);
                return;
            }
            h.overrideUseItem();
            this.clicked = true;
        }
    }

    protected void notFacingBlock(AIHelper h) {
    }

    protected boolean isBlockAllowed(AIHelper h, int blockX, int blockY, int blockZ) {
        return true;
    }
}

