/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.task;

import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.BlockItemFilter;
import net.famzangl.minecraft.minebot.ai.strategy.TaskOperations;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.error.SelectTaskError;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;

public class PlaceBlockTask
extends AITask {
    private final Pos placeOn;
    private final ForgeDirection onSide;
    private int attemptsLeft = 20;
    private final Block block;

    public PlaceBlockTask(Pos placeOn, ForgeDirection onSide, Block block) {
        this.placeOn = placeOn;
        this.onSide = onSide;
        this.block = block;
    }

    @Override
    public boolean isFinished(AIHelper h) {
        return this.attemptsLeft <= 0 || Block.func_149680_a((Block)h.getBlock(this.placeOn.add(this.onSide.offsetX, this.onSide.offsetY, this.onSide.offsetZ)), (Block)this.block);
    }

    @Override
    public void runTick(AIHelper h, TaskOperations o) {
        BlockItemFilter f = new BlockItemFilter(this.block);
        if (!h.selectCurrentItem(f)) {
            o.desync(new SelectTaskError(f));
        }
        h.faceSideOf(this.placeOn.x, this.placeOn.y, this.placeOn.z, this.onSide);
        if (h.isFacingBlock(this.placeOn.x, this.placeOn.y, this.placeOn.z, this.onSide)) {
            h.overrideUseItem();
        }
        --this.attemptsLeft;
    }
}

