/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.task;

import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.task.UseItemTask;
import net.minecraft.client.gui.inventory.GuiChest;

public class OpenChestTask
extends UseItemTask {
    private static final double SIDE_DIST = 0.1;
    private static final double TOP = 0.8;
    private static final double BOTTOM = 0.03;
    private final Pos p1;
    private final Pos p2;
    private int attempts;

    public OpenChestTask(Pos p1, Pos p2) {
        this.p1 = p1;
        this.p2 = p2;
    }

    @Override
    public boolean isFinished(AIHelper h) {
        return h.getMinecraft().field_71462_r instanceof GuiChest;
    }

    @Override
    protected boolean isBlockAllowed(AIHelper h, int blockX, int blockY, int blockZ) {
        return this.p1 != null && blockX == this.p1.x && blockY == this.p1.y && blockZ == this.p1.z || this.p2 != null && blockX == this.p2.x && blockY == this.p2.y && blockZ == this.p2.z;
    }

    @Override
    protected void notFacingBlock(AIHelper h) {
        ++this.attempts;
        this.attempts &= 0xF;
        Pos p = (this.attempts & 8) == 0 && this.p1 != null || this.p2 == null ? this.p1 : this.p2;
        double dx = (this.attempts & 1) != 0 ? 0.1 : 0.9;
        double dy = (this.attempts & 2) != 0 ? 0.03 : 0.8;
        double dz = (this.attempts & 4) != 0 ? 0.1 : 0.9;
        h.face((double)p.x + dx, (double)p.y + dy, (double)p.z + dz);
    }
}

