/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.task;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.strategy.TaskOperations;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.util.MovementInput;
import net.minecraft.util.MovingObjectPosition;

public class FaceAndInteractTask
extends AITask {
    protected boolean interacted = false;
    private final Entity preferedAnimal;
    private final IEntitySelector alsoAcceptedAnimal;
    private final boolean doRightClick;
    private int ticksRun = 0;

    public FaceAndInteractTask(Entity preferedAnimal, IEntitySelector alsoAcceptedAnimal) {
        this(preferedAnimal, alsoAcceptedAnimal, true);
    }

    public FaceAndInteractTask(Entity preferedAnimal, IEntitySelector alsoAcceptedAnimal, boolean doRightClick) {
        this.preferedAnimal = preferedAnimal;
        this.alsoAcceptedAnimal = alsoAcceptedAnimal;
        this.doRightClick = doRightClick;
    }

    @Override
    public boolean isFinished(AIHelper h) {
        boolean collect = this.preferedAnimal instanceof EntityItem || this.preferedAnimal instanceof EntityXPOrb;
        return collect ? this.preferedAnimal.field_70121_D.func_72326_a(h.getMinecraft().field_71439_g.field_70121_D) : this.interacted;
    }

    @Override
    public void runTick(AIHelper h, TaskOperations o) {
        MovingObjectPosition over = h.getObjectMouseOver();
        if (over != null && over.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && this.alsoAcceptedAnimal.func_82704_a(over.field_72308_g)) {
            this.doInteractWithCurrent(h);
        } else {
            double speed = h.getMinecraft().field_71439_g.field_70159_w * h.getMinecraft().field_71439_g.field_70159_w + h.getMinecraft().field_71439_g.field_70179_y * h.getMinecraft().field_71439_g.field_70179_y;
            h.face(this.preferedAnimal.field_70165_t, this.preferedAnimal.field_70163_u, this.preferedAnimal.field_70161_v);
            MovementInput i = new MovementInput();
            i.field_78901_c = speed < 0.01 && this.ticksRun > 8;
            i.field_78900_b = 1.0f;
            h.overrideMovement(i);
        }
        ++this.ticksRun;
    }

    protected void doInteractWithCurrent(AIHelper h) {
        if (this.doRightClick) {
            h.overrideUseItem();
        } else {
            h.overrideAttack();
        }
        this.interacted = true;
    }

    public String toString() {
        return "FaceAndInteractTask [preferedAnimal=" + this.preferedAnimal + ", alsoAcceptedAnimal=" + this.alsoAcceptedAnimal + ", doRightClick=" + this.doRightClick + "]";
    }
}

