/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.enchanting.CloseScreenTask;
import net.famzangl.minecraft.minebot.ai.scanner.BlockRangeFinder;
import net.famzangl.minecraft.minebot.ai.scanner.BlockRangeScanner;
import net.famzangl.minecraft.minebot.ai.scanner.ChestBlockHandler;
import net.famzangl.minecraft.minebot.ai.scanner.SameItemFilter;
import net.famzangl.minecraft.minebot.ai.strategy.InventoryDefinition;
import net.famzangl.minecraft.minebot.ai.strategy.PathFinderStrategy;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.MoveInInventoryTask;
import net.famzangl.minecraft.minebot.ai.task.OpenChestTask;
import net.famzangl.minecraft.minebot.ai.task.WaitTask;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class UnstoreStrategy
extends PathFinderStrategy {
    public UnstoreStrategy(Wishlist list) {
        super(new UnstorePathFinder(list), null);
    }

    @Override
    public void searchTasks(AIHelper helper) {
        if (helper.getMinecraft().field_71462_r instanceof GuiChest) {
            this.addTask(new CloseScreenTask());
        }
        super.searchTasks(helper);
    }

    @Override
    public String getDescription(AIHelper helper) {
        return "Get items out of chest.";
    }

    private static class UnstorePathFinder
    extends BlockRangeFinder {
        private final Wishlist list;
        private ChestBlockHandler chestBlockHandler;

        @Override
        protected BlockRangeScanner constructScanner(Pos playerPosition) {
            BlockRangeScanner scanner = super.constructScanner(playerPosition);
            this.chestBlockHandler = new ChestBlockHandler();
            scanner.addHandler(this.chestBlockHandler);
            return scanner;
        }

        public UnstorePathFinder(Wishlist list) {
            this.list = list;
        }

        @Override
        protected float rateDestination(int distance, int x, int y, int z) {
            ArrayList<ChestBlockHandler.ChestData> chests = this.chestBlockHandler.getChestsForPos(new Pos(x, y, z));
            if (chests != null) {
                for (ChestBlockHandler.ChestData c : chests) {
                    if (!this.list.couldUseOneOf(c)) continue;
                    return distance;
                }
            }
            return -1.0f;
        }

        @Override
        protected void addTasksForTarget(Pos currentPos) {
            ArrayList<ChestBlockHandler.ChestData> chests = this.chestBlockHandler.getChestsForPos(currentPos);
            Iterator<ChestBlockHandler.ChestData> i$ = chests.iterator();
            while (i$.hasNext()) {
                ItemStack[] inventory = this.helper.getMinecraft().field_71439_g.field_71071_by.field_70462_a;
                ChestBlockHandler.ChestData c = i$.next();
                ArrayList<AITask> tasks = this.list.getTakeTasks(inventory, c);
                if (tasks.isEmpty()) continue;
                this.addTask(new OpenChestTask(c.getSecondaryPos(), c.getPos()));
                this.addTask(new WaitTask(5));
                for (AITask t : tasks) {
                    this.addTask(t);
                    this.addTask(new WaitTask(5));
                }
                this.addTask(new CloseScreenTask());
                this.addTask(new WaitTask(5));
            }
        }
    }

    public static class Wishlist {
        InventoryDefinition wantedInventory;
        boolean[] noMoreWork = new boolean[36];

        public Wishlist(InventoryDefinition wantedInventory) {
            this.wantedInventory = wantedInventory;
        }

        public boolean couldUseOneOf(ChestBlockHandler.ChestData c) {
            for (int i = 0; i < 36; ++i) {
                InventoryDefinition.InventorySlot slot = this.wantedInventory.getSlot(i);
                if (slot == null || this.noMoreWork[i] || !c.couldTakeItem(slot.getFakeMcStack())) continue;
                return true;
            }
            return false;
        }

        public ArrayList<AITask> getTakeTasks(ItemStack[] mainInventory, ChestBlockHandler.ChestData c) {
            ArrayList<AITask> tasks = new ArrayList<AITask>();
            for (int inventorySlot = 0; inventorySlot < 36; ++inventorySlot) {
                InventoryDefinition.InventorySlot slot = this.wantedInventory.getSlot(inventorySlot);
                if (slot == null || !c.couldTakeItem(slot.getFakeMcStack())) continue;
                if (mainInventory[inventorySlot] != null) {
                    if (!new SameItemFilter(mainInventory[inventorySlot]).matches(slot.getFakeMcStack())) {
                        System.out.println("This slot already contains an other item.");
                        this.noMoreWork[inventorySlot] = true;
                        continue;
                    }
                    if (mainInventory[inventorySlot].field_77994_a >= Math.min(mainInventory[inventorySlot].func_77976_d(), slot.amount)) {
                        System.out.println("This slot already contains enough items.");
                        this.noMoreWork[inventorySlot] = true;
                        continue;
                    }
                }
                tasks.add(this.getTask(inventorySlot, slot, c));
            }
            return tasks;
        }

        private MoveInInventoryTask getTask(final int inventorySlot, final InventoryDefinition.InventorySlot slot, final ChestBlockHandler.ChestData c) {
            return new MoveInInventoryTask(){
                private int fromStack = -2;

                @Override
                public boolean isFinished(AIHelper h) {
                    return Wishlist.this.noMoreWork[inventorySlot] || super.isFinished(h);
                }

                @Override
                protected int getToStack(AIHelper h) {
                    GuiChest screen = (GuiChest)h.getMinecraft().field_71462_r;
                    int slots = screen.field_147002_h.field_75151_b.size();
                    int iSlot = inventorySlot < 9 ? inventorySlot + 27 : inventorySlot - 9;
                    return iSlot + (slots - 36);
                }

                @Override
                protected int getFromStack(AIHelper h) {
                    if (this.fromStack == -2) {
                        this.fromStack = -1;
                        GuiChest screen = (GuiChest)h.getMinecraft().field_71462_r;
                        SameItemFilter filter = new SameItemFilter(slot.getFakeMcStack());
                        List inventorySlots = screen.field_147002_h.field_75151_b;
                        for (int i = 0; i < inventorySlots.size() - 36; ++i) {
                            Slot s = (Slot)inventorySlots.get(i);
                            if (!filter.matches(s.func_75211_c())) continue;
                            this.fromStack = i;
                            break;
                        }
                        if (this.fromStack < 0) {
                            System.out.println("Empty stack.");
                            c.markAsEmptyFor(slot.getFakeMcStack(), true);
                        }
                    }
                    return this.fromStack;
                }

                @Override
                protected int getMissingAmount(AIHelper h, int currentCount) {
                    return -currentCount + slot.amount;
                }
            };
        }
    }
}

