/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;

public class StrategyStack {
    private final ArrayList<AIStrategy> strategies = new ArrayList();
    private AIStrategy currentStrategy = null;
    private boolean paused;
    private boolean goodPause;

    public AIStrategy.TickResult gameTick(AIHelper helper) {
        AIStrategy.TickResult result = this.strategyTick(helper, this.currentStrategy == null || this.goodPause);
        this.goodPause = false;
        if (result == null) {
            return AIStrategy.TickResult.NO_MORE_WORK;
        }
        if (result == AIStrategy.TickResult.NO_MORE_WORK) {
            this.setCurrentStrategy(helper, null);
            return AIStrategy.TickResult.TICK_AGAIN;
        }
        if (result == AIStrategy.TickResult.TICK_AGAIN) {
            this.goodPause = true;
        }
        return result;
    }

    private AIStrategy.TickResult strategyTick(AIHelper helper, boolean goodTimeToPause) {
        for (AIStrategy s : this.strategies) {
            if (s == this.currentStrategy) {
                return s.gameTick(helper);
            }
            if (!goodTimeToPause && !s.takesOverAnyTime() || !s.checkShouldTakeOver(helper)) continue;
            this.setCurrentStrategy(helper, s);
            return s.gameTick(helper);
        }
        return null;
    }

    private void setCurrentStrategy(AIHelper helper, AIStrategy s) {
        if (this.currentStrategy != null) {
            this.currentStrategy.setActive(false, helper);
        }
        this.currentStrategy = s;
        if (this.currentStrategy != null) {
            this.currentStrategy.setActive(true, helper);
        }
    }

    public void addStrategy(AIStrategy strategy) {
        if (strategy.isActive()) {
            throw new IllegalArgumentException("Attempting to add an active strategy to this stack.");
        }
        if (this.strategies.contains(strategy)) {
            throw new IllegalArgumentException("Added a strategy twice.");
        }
        this.strategies.add(strategy);
    }

    public void pause(AIHelper helper) {
        this.setCurrentStrategy(helper, null);
        this.paused = true;
    }

    public void resume(AIHelper helper) {
        this.paused = false;
    }

    public void shutdown() {
    }

    public AIStrategy getCurrentStrategy() {
        return this.currentStrategy;
    }

    public boolean couldTakeOver(AIHelper helper) {
        for (AIStrategy s : this.strategies) {
            if (!s.checkShouldTakeOver(helper)) continue;
            return true;
        }
        return false;
    }

    public List<AIStrategy> getStrategies() {
        return Collections.unmodifiableList(this.strategies);
    }
}

