/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import java.util.ArrayList;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.enchanting.CloseScreenTask;
import net.famzangl.minecraft.minebot.ai.scanner.BlockRangeFinder;
import net.famzangl.minecraft.minebot.ai.scanner.BlockRangeScanner;
import net.famzangl.minecraft.minebot.ai.scanner.ChestBlockHandler;
import net.famzangl.minecraft.minebot.ai.strategy.PathFinderStrategy;
import net.famzangl.minecraft.minebot.ai.task.OpenChestTask;
import net.famzangl.minecraft.minebot.ai.task.PutInChestTask;
import net.famzangl.minecraft.minebot.ai.task.WaitTask;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.item.ItemStack;

public class StoreStrategy
extends PathFinderStrategy {
    public StoreStrategy() {
        super(new StorePathFinder(), null);
    }

    @Override
    public void searchTasks(AIHelper helper) {
        if (helper.getMinecraft().field_71462_r instanceof GuiChest) {
            this.addTask(new CloseScreenTask());
        }
        super.searchTasks(helper);
    }

    @Override
    public String getDescription(AIHelper helper) {
        return "Put inventory in chest.";
    }

    private static class StorePathFinder
    extends BlockRangeFinder {
        private ChestBlockHandler chestBlockHandler;

        private StorePathFinder() {
        }

        @Override
        protected BlockRangeScanner constructScanner(Pos playerPosition) {
            BlockRangeScanner scanner = super.constructScanner(playerPosition);
            this.chestBlockHandler = new ChestBlockHandler();
            scanner.addHandler(this.chestBlockHandler);
            return scanner;
        }

        @Override
        protected float rateDestination(int distance, int x, int y, int z) {
            ArrayList<ChestBlockHandler.ChestData> chests = this.chestBlockHandler.getChestsForPos(new Pos(x, y, z));
            if (chests != null) {
                for (ChestBlockHandler.ChestData c : chests) {
                    for (ItemStack s : this.helper.getMinecraft().field_71439_g.field_71071_by.field_70462_a) {
                        if (!c.isItemAllowed(s)) continue;
                        return distance;
                    }
                }
            }
            return -1.0f;
        }

        @Override
        protected void addTasksForTarget(Pos currentPos) {
            ArrayList<ChestBlockHandler.ChestData> chests = this.chestBlockHandler.getChestsForPos(currentPos);
            for (final ChestBlockHandler.ChestData c : chests) {
                boolean chestOpen = false;
                ItemStack[] inventory = this.helper.getMinecraft().field_71439_g.field_71071_by.field_70462_a;
                for (int i = 0; i < inventory.length; ++i) {
                    final ItemStack s = inventory[i];
                    if (!c.couldPutItem(s)) continue;
                    if (!chestOpen) {
                        this.addTask(new OpenChestTask(c.getSecondaryPos(), c.getPos()));
                        this.addTask(new WaitTask(5));
                        chestOpen = true;
                    }
                    this.addTask(new PutInChestTask(i){

                        @Override
                        protected void containerIsFull() {
                            super.containerIsFull();
                            c.markAsFullFor(s, true);
                        }
                    });
                    this.addTask(new WaitTask(5));
                }
                if (!chestOpen) continue;
                this.addTask(new CloseScreenTask());
                this.addTask(new WaitTask(5));
                chestOpen = false;
                break;
            }
        }
    }
}

