/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.ItemFilter;
import net.famzangl.minecraft.minebot.ai.selectors.AndSelector;
import net.famzangl.minecraft.minebot.ai.selectors.ColorSelector;
import net.famzangl.minecraft.minebot.ai.selectors.ItemSelector;
import net.famzangl.minecraft.minebot.ai.selectors.OrSelector;
import net.famzangl.minecraft.minebot.ai.strategy.TaskStrategy;
import net.famzangl.minecraft.minebot.ai.task.FaceAndInteractTask;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;

public class ShearStrategy
extends TaskStrategy {
    private static final int DISTANCE = 20;
    private final int color;

    public ShearStrategy(int color) {
        this.color = color;
    }

    @Override
    public void searchTasks(AIHelper helper) {
        Entity found;
        if (!helper.selectCurrentItem(new ShearsFilter())) {
            return;
        }
        Object selector = new SheepSelector();
        if (this.color >= 0) {
            selector = new AndSelector(new IEntitySelector[]{selector, new ColorSelector(this.color)});
        }
        if ((found = helper.getClosestEntity(20, new OrSelector(new IEntitySelector[]{selector, new ItemSelector()}))) != null) {
            this.addTask(new FaceAndInteractTask(found, (IEntitySelector)selector));
        }
    }

    @Override
    public String getDescription(AIHelper helper) {
        return "Shearing...";
    }

    private final class SheepSelector
    implements IEntitySelector {
        private SheepSelector() {
        }

        public boolean func_82704_a(Entity var1) {
            return var1 instanceof EntitySheep && ((EntitySheep)var1).isShearable(null, null, 0, 0, 0);
        }
    }

    private final class ShearsFilter
    implements ItemFilter {
        private ShearsFilter() {
        }

        @Override
        public boolean matches(ItemStack itemStack) {
            return itemStack != null && itemStack.func_77973_b() instanceof ItemShears;
        }
    }
}

