/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;

public class PauseStrategy
extends AIStrategy {
    private int leftTicks;
    private boolean shouldTickAgain;

    public PauseStrategy(int seconds) {
        this.leftTicks = seconds * 20;
    }

    @Override
    public boolean checkShouldTakeOver(AIHelper helper) {
        return this.leftTicks > 0;
    }

    @Override
    protected AIStrategy.TickResult onGameTick(AIHelper helper) {
        if (this.shouldTickAgain) {
            this.shouldTickAgain = false;
            return AIStrategy.TickResult.TICK_AGAIN;
        }
        if (this.leftTicks > 0) {
            --this.leftTicks;
            this.shouldTickAgain = true;
            return AIStrategy.TickResult.TICK_HANDLED;
        }
        return AIStrategy.TickResult.NO_MORE_WORK;
    }

    @Override
    public String getDescription(AIHelper helper) {
        return "Pausing for " + this.leftTicks / 20 + "s";
    }
}

