/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import com.google.gson.Gson;
import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class InventoryDefinition {
    private final ArrayList<InventorySlot> slots = new ArrayList();

    public InventoryDefinition(InventoryPlayer player) {
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = player.field_70462_a[i];
            if (stack == null) continue;
            stack.func_77973_b();
            this.slots.add(new InventorySlot(i, stack.field_77994_a, Item.func_150891_b((Item)stack.func_77973_b()), stack.func_77981_g() ? stack.func_77960_j() : -1));
        }
    }

    public InventoryDefinition(String serialized) {
        InventorySlot[] slots;
        Gson gson = new Gson();
        for (InventorySlot s : slots = (InventorySlot[])gson.fromJson(serialized, InventorySlot[].class)) {
            this.slots.add(s);
        }
    }

    public InventorySlot getSlot(int i) {
        for (InventorySlot s : this.slots) {
            if (s.slotIndex != i) continue;
            return s;
        }
        return null;
    }

    public static class InventorySlot {
        public final int slotIndex;
        public final int amount;
        public final int itemId;
        public final int damageValue;

        public InventorySlot(int slotIndex, int amount, int itemId, int damageValue) {
            this.slotIndex = slotIndex;
            this.amount = amount;
            this.itemId = itemId;
            this.damageValue = damageValue;
        }

        public ItemStack getFakeMcStack() {
            ItemStack stack = new ItemStack(Item.func_150899_d((int)this.itemId));
            stack.field_77994_a = this.amount;
            if (stack.func_77981_g()) {
                stack.func_77964_b(this.damageValue);
            }
            return stack;
        }
    }
}

