/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.selectors.AndSelector;
import net.famzangl.minecraft.minebot.ai.selectors.ColorSelector;
import net.famzangl.minecraft.minebot.ai.selectors.FeedableSelector;
import net.famzangl.minecraft.minebot.ai.selectors.FilterFeedingItem;
import net.famzangl.minecraft.minebot.ai.selectors.OrSelector;
import net.famzangl.minecraft.minebot.ai.selectors.XPOrbSelector;
import net.famzangl.minecraft.minebot.ai.strategy.TaskStrategy;
import net.famzangl.minecraft.minebot.ai.task.FaceAndInteractTask;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;

public class FeedAnimalsStrategy
extends TaskStrategy {
    private static final int DISTANCE = 20;
    private final int color;

    public FeedAnimalsStrategy() {
        this(-1);
    }

    public FeedAnimalsStrategy(int color) {
        this.color = color;
    }

    @Override
    public void searchTasks(AIHelper helper) {
        this.feedWithFood(helper);
    }

    private void feedWithFood(AIHelper helper) {
        Object selector = new FeedableSelector(helper);
        if (this.color >= 0) {
            selector = new AndSelector(new IEntitySelector[]{selector, new ColorSelector(this.color)});
        }
        XPOrbSelector collect = new XPOrbSelector();
        final Entity found = helper.getClosestEntity(20, new OrSelector(new IEntitySelector[]{selector, collect}));
        if (found != null) {
            this.addTask(new FaceAndInteractTask(found, (IEntitySelector)selector){

                @Override
                protected void doInteractWithCurrent(AIHelper h) {
                    Entity over = h.getObjectMouseOver().field_72308_g;
                    if (over instanceof EntityAnimal && h.selectCurrentItem(new FilterFeedingItem((EntityAnimal)over))) {
                        super.doInteractWithCurrent(h);
                    } else if (found == over) {
                        this.interacted = true;
                    }
                }
            });
        }
    }

    @Override
    public String getDescription(AIHelper helper) {
        return "Feeding";
    }
}

