/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.util.MovementInput;
import net.minecraft.util.MovingObjectPosition;

public abstract class FaceInteractStrategy
extends AIStrategy {
    private static final int DISTANCE = 20;
    private int ticksRun;

    @Override
    public boolean checkShouldTakeOver(AIHelper helper) {
        return this.getCloseEntity(helper) != null;
    }

    @Override
    protected AIStrategy.TickResult onGameTick(AIHelper helper) {
        Entity found = this.getCloseEntity(helper);
        if (found == null) {
            this.ticksRun = 0;
            return AIStrategy.TickResult.NO_MORE_WORK;
        }
        MovingObjectPosition over = helper.getObjectMouseOver();
        if (over != null && over.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && this.doInteractWithCurrent(over.field_72308_g, helper)) {
            this.ticksRun = 0;
        } else {
            double speed = helper.getMinecraft().field_71439_g.field_70159_w * helper.getMinecraft().field_71439_g.field_70159_w + helper.getMinecraft().field_71439_g.field_70179_y * helper.getMinecraft().field_71439_g.field_70179_y;
            helper.face(found.field_70165_t, found.field_70163_u, found.field_70161_v);
            MovementInput i = new MovementInput();
            i.field_78901_c = speed < 0.01 && this.ticksRun > 8;
            i.field_78900_b = 1.0f;
            helper.overrideMovement(i);
            ++this.ticksRun;
        }
        return AIStrategy.TickResult.TICK_HANDLED;
    }

    private boolean doInteractWithCurrent(Entity entityHit, AIHelper helper) {
        if (this.entitiesToInteract(helper).func_82704_a(entityHit)) {
            this.doInteract(entityHit, helper);
            return true;
        }
        return false;
    }

    protected void doInteract(Entity entityHit, AIHelper helper) {
        helper.overrideUseItem();
    }

    private Entity getCloseEntity(AIHelper helper) {
        IEntitySelector collect = this.entitiesToFace(helper);
        Entity found = helper.getClosestEntity(20, collect);
        return found;
    }

    protected abstract IEntitySelector entitiesToInteract(AIHelper var1);

    protected IEntitySelector entitiesToFace(AIHelper helper) {
        return this.entitiesToInteract(helper);
    }
}

