/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.scanner;

import java.util.ArrayList;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;

public class BlockRangeScanner {
    private static final int HORIZONTAL_SCAN = 100;
    private static final int VERTICAL_SCAN = 20;
    private final Pos center;
    private final BlockHandler[] handlersCache = new BlockHandler[4096];
    private final ArrayList<BlockHandler> handlers = new ArrayList();
    private boolean scaningFinished;

    public BlockRangeScanner(Pos center) {
        this.center = center;
    }

    public void addHandler(BlockHandler h) {
        this.handlers.add(h);
        for (int i : h.getIds()) {
            this.handlersCache[i] = h;
        }
    }

    public void scanArea(AIHelper helper) {
        for (int y = this.center.y - 20; y <= this.center.y + 20; ++y) {
            for (int z = this.center.z - 100; z <= this.center.z + 100; ++z) {
                for (int x = this.center.x - 100; x <= this.center.x + 100; ++x) {
                    int id = helper.getBlockId(x, y, z);
                    BlockHandler handler = this.handlersCache[id];
                    if (handler == null) continue;
                    handler.scanBlock(helper, id, x, y, z);
                }
            }
        }
        for (BlockHandler handler : this.handlers) {
            handler.scanningDone(helper);
        }
        this.scaningFinished = true;
    }

    public void startAsync(final AIHelper helper) {
        new Thread("Block range finder"){

            @Override
            public void run() {
                try {
                    BlockRangeScanner.this.scanArea(helper);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BlockRangeScanner.this.scaningFinished = true;
                }
            }
        }.start();
    }

    public boolean isScaningFinished() {
        return this.scaningFinished;
    }

    public static interface BlockHandler {
        public int[] getIds();

        public void scanningDone(AIHelper var1);

        public void scanBlock(AIHelper var1, int var2, int var3, int var4, int var5);
    }
}

