/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.path;

import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.BlockWhitelist;
import net.famzangl.minecraft.minebot.ai.ItemFilter;
import net.famzangl.minecraft.minebot.ai.path.MovePathFinder;
import net.famzangl.minecraft.minebot.ai.task.UseItemOnBlockAtTask;
import net.famzangl.minecraft.minebot.ai.task.place.DestroyBlockTask;
import net.famzangl.minecraft.minebot.ai.task.place.PlaceBlockAtFloorTask;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;

public class PlantPathFinder
extends MovePathFinder {
    private final PlantType type;
    private static final BlockWhitelist farmlandable = new BlockWhitelist(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c});

    public PlantPathFinder(PlantType type) {
        this.type = type;
        this.allowedGroundForUpwardsBlocks = this.allowedGroundBlocks;
        this.footAllowedBlocks = AIHelper.walkableBlocks;
        this.headAllowedBlocks = AIHelper.headWalkableBlocks;
    }

    @Override
    protected float rateDestination(int distance, int x, int y, int z) {
        if (this.isGrown(this.helper, x, y, z)) {
            return distance + 1;
        }
        if (this.helper.isAirBlock(x, y, z) && this.hasFarmlandBelow(x, y, z) && this.helper.canSelectItem(new SeedFilter(this.type))) {
            return distance + 1;
        }
        if (this.type.farmland == Blocks.field_150458_ak && this.helper.isAirBlock(x, y, z) && farmlandable.contains(this.helper.getBlock(x, y - 1, z)) && this.helper.canSelectItem(new SeedFilter(this.type)) && this.helper.canSelectItem(new HoeFilter())) {
            return distance + 10;
        }
        return -1.0f;
    }

    private boolean isGrown(AIHelper helper, int x, int y, int z) {
        Block block = helper.getBlock(x, y, z);
        if (block instanceof BlockCrops) {
            int metadata = helper.getMinecraft().field_71441_e.func_72805_g(x, y, z);
            return metadata >= 7;
        }
        return false;
    }

    private boolean hasFarmlandBelow(int x, int y, int z) {
        return Block.func_149680_a((Block)this.helper.getBlock(x, y - 1, z), (Block)this.type.farmland);
    }

    @Override
    protected void addTasksForTarget(Pos currentPos) {
        if (this.helper.isAirBlock(currentPos.x, currentPos.y, currentPos.z)) {
            if (!this.hasFarmlandBelow(currentPos.x, currentPos.y, currentPos.z)) {
                this.addTask(new UseItemOnBlockAtTask(new HoeFilter(), currentPos.x, currentPos.y - 1, currentPos.z));
            }
            this.addTask(new PlaceBlockAtFloorTask(currentPos.x, currentPos.y, currentPos.z, new SeedFilter(this.type)));
        } else {
            this.addTask(new DestroyBlockTask(currentPos.x, currentPos.y, currentPos.z));
        }
    }

    private final class SeedFilter
    implements ItemFilter {
        private final PlantType type;

        public SeedFilter(PlantType type) {
            this.type = type;
        }

        @Override
        public boolean matches(ItemStack itemStack) {
            return itemStack != null && this.type.canPlantItem(itemStack.func_77973_b());
        }
    }

    private final class HoeFilter
    implements ItemFilter {
        private HoeFilter() {
        }

        @Override
        public boolean matches(ItemStack itemStack) {
            return itemStack != null && itemStack.func_77973_b() instanceof ItemHoe;
        }
    }

    public static enum PlantType {
        ANY(Blocks.field_150458_ak, Items.field_151014_N, Items.field_151172_bF, Items.field_151174_bG),
        WHEAT(Blocks.field_150458_ak, Items.field_151014_N),
        CARROT(Blocks.field_150458_ak, Items.field_151172_bF),
        POTATO(Blocks.field_150458_ak, Items.field_151174_bG),
        NETHERWART(Blocks.field_150425_aM, Items.field_151075_bm);

        public final Block farmland;
        private final Item[] items;

        private PlantType(Block farmland, Item ... items) {
            this.farmland = farmland;
            this.items = items;
        }

        public boolean canPlantItem(Item item) {
            for (Item i : this.items) {
                if (item != i) continue;
                return true;
            }
            return false;
        }
    }
}

