/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.path;

import java.util.HashSet;
import java.util.LinkedList;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.BlockWhitelist;
import net.famzangl.minecraft.minebot.ai.path.MovePathFinder;
import net.famzangl.minecraft.minebot.ai.task.DestroyInRangeTask;
import net.minecraft.init.Blocks;

public class ClearAreaPathfinder
extends MovePathFinder {
    private final Pos minPos;
    private final Pos maxPos;
    private int topY;
    private final HashSet<Pos> foundPositions = new HashSet();
    private Pos pathEndPosition;
    private static final BlockWhitelist clearedBlocks = new BlockWhitelist(Blocks.field_150350_a, Blocks.field_150478_aa);

    public ClearAreaPathfinder(Pos pos1, Pos pos2) {
        this.minPos = Pos.minPos(pos1, pos2);
        this.maxPos = Pos.maxPos(pos1, pos2);
        this.topY = this.maxPos.y;
    }

    @Override
    protected boolean runSearch(Pos playerPosition) {
        this.foundPositions.clear();
        this.pathEndPosition = playerPosition;
        do {
            boolean finished;
            if (finished = super.runSearch(this.pathEndPosition)) continue;
            return false;
        } while (this.foundPositions.size() < 20 && this.pathEndPosition != null);
        return true;
    }

    @Override
    protected void foundPath(LinkedList<Pos> path) {
        for (Pos p : path) {
            this.foundPositions.add(p);
            this.foundPositions.add(p.add(0, 1, 0));
            this.pathEndPosition = p;
        }
        super.foundPath(path);
    }

    @Override
    protected void noPathFound() {
        this.pathEndPosition = null;
        super.noPathFound();
    }

    @Override
    protected float rateDestination(int distance, int x, int y, int z) {
        if (this.isInArea(x, y, z) && (!this.isTemporaryCleared(x, y, z) || !this.isTemporaryCleared(x, y + 1, z) && y < this.maxPos.y)) {
            float bonus = 1.0E-4f * (float)(x - this.minPos.x) + 0.001f * (float)(y - this.minPos.y);
            int layerMalus = this.topY <= y ? 5 : (!this.isInArea(x, y + 1, z) || this.isTemporaryCleared(x, y + 1, z) ? 2 : (this.isInArea(x, y + 1, z) && !this.isTemporaryCleared(x, y + 2, z) ? 2 : 0));
            return (float)distance + bonus + (float)layerMalus + (float)((this.maxPos.y - y) * 2);
        }
        return -1.0f;
    }

    private boolean isTemporaryCleared(int x, int y, int z) {
        return ClearAreaPathfinder.isClearedBlock(this.helper, x, y, z) || this.foundPositions.contains(new Pos(x, y, z));
    }

    private boolean isInArea(int x, int y, int z) {
        return this.minPos.x <= x && x <= this.maxPos.x && this.minPos.y <= y && y <= this.maxPos.y && this.minPos.z <= z && z <= this.maxPos.z;
    }

    private static boolean isClearedBlock(AIHelper helper, int x, int y, int z) {
        return clearedBlocks.contains(helper.getBlockId(x, y, z));
    }

    @Override
    protected void addTasksForTarget(Pos currentPos) {
        super.addTasksForTarget(currentPos);
        Pos top = currentPos;
        for (int i = 1; i < 6; ++i) {
            Pos pos = currentPos.add(0, i, 0);
            if (pos.y > this.maxPos.y) continue;
            top = pos;
        }
        this.addTask(new DestroyInRangeTask(currentPos, top));
    }

    @Override
    protected int materialDistance(int x, int y, int z, boolean asFloor) {
        return this.isInArea(x, y, z) ? 0 : super.materialDistance(x, y, z, asFloor);
    }

    public int getAreaSize() {
        return (this.maxPos.x - this.minPos.x + 1) * (this.maxPos.y - this.minPos.y + 1) * (this.maxPos.z - this.minPos.z + 1);
    }

    public float getToClearCount(AIHelper helper) {
        int count = 0;
        int newTopY = this.minPos.y;
        for (int y = this.minPos.y; y <= this.maxPos.y; ++y) {
            for (int z = this.minPos.z; z <= this.maxPos.z; ++z) {
                for (int x = this.minPos.x; x <= this.maxPos.x; ++x) {
                    if (ClearAreaPathfinder.isClearedBlock(helper, x, y, z)) continue;
                    ++count;
                    newTopY = Math.max(y, newTopY);
                }
            }
        }
        this.topY = newTopY;
        System.out.println("top Y:  " + newTopY);
        return count;
    }
}

