/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.commands;

import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.command.AICommand;
import net.famzangl.minecraft.minebot.ai.command.AICommandInvocation;
import net.famzangl.minecraft.minebot.ai.command.AICommandParameter;
import net.famzangl.minecraft.minebot.ai.command.ParameterType;
import net.famzangl.minecraft.minebot.ai.command.SafeStrategyRule;
import net.famzangl.minecraft.minebot.ai.path.TunnelPathFinder;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;
import net.famzangl.minecraft.minebot.ai.strategy.PathFinderStrategy;
import net.minecraftforge.common.util.ForgeDirection;

@AICommand(helpText="Build a tunnel with the given profile", name="minebot")
public class CommandTunnel {
    @AICommandInvocation(safeRule=SafeStrategyRule.DEFEND_MINING)
    public static AIStrategy run(AIHelper helper, @AICommandParameter(type=ParameterType.FIXED, fixedName="tunnel", description="") String nameArg, @AICommandParameter(type=ParameterType.ENUM, description="direction", optional=true) ForgeDirection inDirection, @AICommandParameter(type=ParameterType.ENUM, description="torch side", optional=true) TunnelPathFinder.TorchSide torches, @AICommandParameter(type=ParameterType.NUMBER, description="max length") int length) {
        return CommandTunnel.run(helper, nameArg, inDirection, 0, 0, torches, length);
    }

    @AICommandInvocation(safeRule=SafeStrategyRule.DEFEND_MINING)
    public static AIStrategy run(AIHelper helper, @AICommandParameter(type=ParameterType.FIXED, fixedName="tunnel", description="") String nameArg, @AICommandParameter(type=ParameterType.ENUM, description="direction", optional=true) ForgeDirection inDirection, @AICommandParameter(type=ParameterType.NUMBER, description="add to side") int addToSide, @AICommandParameter(type=ParameterType.NUMBER, description="add to top") int addToTop, @AICommandParameter(type=ParameterType.ENUM, description="torch side", optional=true) TunnelPathFinder.TorchSide torches, @AICommandParameter(type=ParameterType.NUMBER, description="max length") Integer length) {
        if (inDirection == null) {
            inDirection = helper.getLookDirection();
        }
        if (torches == null) {
            torches = TunnelPathFinder.TorchSide.NONE;
        }
        if (length == null) {
            length = -1;
        }
        Pos pos = helper.getPlayerPosition();
        return new PathFinderStrategy(new TunnelPathFinder(inDirection.offsetX, inDirection.offsetZ, pos.x, pos.y, pos.z, addToSide, addToTop, torches, length), "Tunneling");
    }
}

