/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Scanner;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.command.AIChatController;
import net.famzangl.minecraft.minebot.ai.command.AICommand;
import net.famzangl.minecraft.minebot.ai.command.AICommandInvocation;
import net.famzangl.minecraft.minebot.ai.command.AICommandParameter;
import net.famzangl.minecraft.minebot.ai.command.IAIControllable;
import net.famzangl.minecraft.minebot.ai.command.ParameterType;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;
import net.famzangl.minecraft.minebot.ai.strategy.StackStrategy;
import net.famzangl.minecraft.minebot.ai.strategy.StrategyStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;

@AICommand(helpText="Run commands from a file.", name="minebot")
public class CommandRun {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AIStrategy runAndGetStrategy(AIHelper helper, String command) {
        IAIControllable controlled = AIChatController.getRegistry().getControlled();
        StrategyReceiver tempController = new StrategyReceiver(controlled);
        try {
            AIChatController.getRegistry().setControlled(tempController);
            CommandRun.runCommand(helper, command);
        }
        finally {
            AIChatController.getRegistry().setControlled(controlled);
        }
        return tempController.getReceivedStrategy();
    }

    public static void runCommand(AIHelper helper, String command) {
        if (helper.getMinecraft().field_71456_v.func_146158_b() != null) {
            GuiChat chat = new GuiChat();
            chat.field_146297_k = helper.getMinecraft();
            chat.func_146403_a(command);
        }
    }

    @AICommandInvocation
    public static AIStrategy run(AIHelper helper, @AICommandParameter(type=ParameterType.FIXED, fixedName="run", description="") String nameArg, @AICommandParameter(type=ParameterType.FILE, description="") String file) {
        return new RunFileStrategy(file);
    }

    private static final class RunFileStrategy
    extends AIStrategy {
        private final String fileName;
        private LinkedList<String> commands = null;
        private IOException exception = null;
        private boolean fileRead;
        private boolean exceptionReported;
        private AIStrategy activeStrategy;
        private boolean repeatMode = false;
        private int stackMaxLeft = -1;
        private StrategyStack stack;

        public RunFileStrategy(String fileName) {
            this.fileName = fileName;
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        RunFileStrategy.this.commands = this.readFile(new File(RunFileStrategy.this.fileName));
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        RunFileStrategy.this.exception = e;
                    }
                    finally {
                        RunFileStrategy.this.fileRead = true;
                    }
                }

                private LinkedList<String> readFile(File file) throws FileNotFoundException {
                    LinkedList<String> commands = new LinkedList<String>();
                    Scanner reader = new Scanner(file);
                    while (reader.hasNextLine()) {
                        String line = reader.nextLine();
                        if (line.startsWith("#") || line.isEmpty()) continue;
                        commands.add(line);
                    }
                    reader.close();
                    return commands;
                }
            }.start();
        }

        @Override
        public boolean checkShouldTakeOver(AIHelper helper) {
            return !this.fileRead || (this.exception != null ? !this.exceptionReported : !this.commands.isEmpty());
        }

        @Override
        protected AIStrategy.TickResult onGameTick(AIHelper helper) {
            if (!this.fileRead) {
                return AIStrategy.TickResult.TICK_HANDLED;
            }
            if (this.exception != null) {
                if (!this.exceptionReported) {
                    AIChatController.addChatLine("Error while reading file: " + this.exception.getMessage());
                    this.exceptionReported = true;
                }
                return AIStrategy.TickResult.NO_MORE_WORK;
            }
            if (this.activeStrategy != null) {
                AIStrategy.TickResult result = this.activeStrategy.gameTick(helper);
                if (result == AIStrategy.TickResult.NO_MORE_WORK) {
                    this.activeStrategy.setActive(false, helper);
                    this.activeStrategy = null;
                    return AIStrategy.TickResult.TICK_AGAIN;
                }
                return result;
            }
            if (this.stack != null) {
                if (this.stackMaxLeft == 0 || this.commands.isEmpty()) {
                    AIChatController.addChatLine("Stack has no end.");
                    return AIStrategy.TickResult.NO_MORE_WORK;
                }
                String command = this.getNextCommand();
                if (command.equals("stack end")) {
                    this.setActiveStrategy(helper, new StackStrategy(this.stack));
                    this.stack = null;
                    this.stackMaxLeft = -1;
                    return AIStrategy.TickResult.TICK_AGAIN;
                }
                AIStrategy receivedStrategy = CommandRun.runAndGetStrategy(helper, command);
                if (receivedStrategy == null) {
                    AIChatController.addChatLine("Command is not a strategy: " + command);
                    return AIStrategy.TickResult.ABORT;
                }
                this.stack.addStrategy(receivedStrategy);
                return AIStrategy.TickResult.TICK_AGAIN;
            }
            if (this.commands.isEmpty()) {
                AIChatController.addChatLine("Done");
                return AIStrategy.TickResult.NO_MORE_WORK;
            }
            String command = this.getNextCommand();
            if (command.equals("repeat:")) {
                this.repeatMode = true;
            } else if (command.equals("stack:")) {
                this.stackMaxLeft = this.commands.size();
                this.stack = new StrategyStack();
            } else {
                AIStrategy receivedStrategy = CommandRun.runAndGetStrategy(helper, command);
                if (receivedStrategy != null) {
                    this.setActiveStrategy(helper, receivedStrategy);
                }
            }
            return AIStrategy.TickResult.TICK_AGAIN;
        }

        private String getNextCommand() {
            String command = this.commands.removeFirst();
            if (this.repeatMode) {
                this.commands.add(command);
            }
            return command;
        }

        private void setActiveStrategy(AIHelper helper, AIStrategy receivedStrategy) {
            this.activeStrategy = receivedStrategy;
            this.activeStrategy.setActive(true, helper);
        }

        @Override
        public String getDescription(AIHelper helper) {
            return "Running from file..." + (this.activeStrategy != null ? "\n" + this.activeStrategy.getDescription(helper) : "");
        }
    }

    private static final class StrategyReceiver
    implements IAIControllable {
        private final IAIControllable controlled;
        private AIStrategy receivedStrategy;

        private StrategyReceiver(IAIControllable controlled) {
            this.controlled = controlled;
        }

        @Override
        public void requestUseStrategy(AIStrategy strategy) {
            this.receivedStrategy = strategy;
        }

        @Override
        public Minecraft getMinecraft() {
            return this.controlled.getMinecraft();
        }

        @Override
        public AIHelper getAiHelper() {
            return this.controlled.getAiHelper();
        }

        public AIStrategy getReceivedStrategy() {
            return this.receivedStrategy;
        }
    }
}

